/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisXMLConfigBuilder;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.SqlRunnerInjector;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class MybatisSqlSessionFactoryBuilder
extends SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader, String environment, Properties properties) {
        try {
            MybatisXMLConfigBuilder parser = new MybatisXMLConfigBuilder(reader, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        try {
            MybatisXMLConfigBuilder parser = new MybatisXMLConfigBuilder(inputStream, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(Configuration config) {
        IdentifierGenerator identifierGenerator;
        MybatisConfiguration configuration = (MybatisConfiguration)config;
        GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig(configuration);
        if (globalConfig.getIdentifierGenerator() == null) {
            identifierGenerator = null != globalConfig.getWorkerId() && null != globalConfig.getDatacenterId() ? new DefaultIdentifierGenerator(globalConfig.getWorkerId(), globalConfig.getDatacenterId()) : new DefaultIdentifierGenerator();
            globalConfig.setIdentifierGenerator(identifierGenerator);
        } else {
            identifierGenerator = globalConfig.getIdentifierGenerator();
        }
        IdWorker.setIdentifierGenerator(identifierGenerator);
        if (globalConfig.isEnableSqlRunner()) {
            new SqlRunnerInjector().inject(configuration);
        }
        SqlSessionFactory sqlSessionFactory = super.build((Configuration)configuration);
        globalConfig.setSqlSessionFactory(sqlSessionFactory);
        return sqlSessionFactory;
    }
}

