/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.load;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.entity.enums.FileMappingStatus;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.entity.load.FileSetting;
import org.apache.hugegraph.entity.load.FileUploadResult;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.mapper.load.FileMappingMapper;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.hugegraph.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileMappingService {
    private static final Logger log = LogManager.getLogger(FileMappingService.class);
    public static final String CONN_PREIFX = "graph-connection-";
    public static final String JOB_PREIFX = "job-";
    public static final String FILE_PREIFX = "file-mapping-";
    @Autowired
    private HugeConfig config;
    @Autowired
    private FileMappingMapper mapper;
    private final Map<String, ReadWriteLock> uploadingTokenLocks = new ConcurrentHashMap<String, ReadWriteLock>();

    public Map<String, ReadWriteLock> getUploadingTokenLocks() {
        return this.uploadingTokenLocks;
    }

    public FileMapping get(int id) {
        return (FileMapping)this.mapper.selectById(Integer.valueOf(id));
    }

    public FileMapping get(int connId, int jobId, String fileName) {
        QueryWrapper query = Wrappers.query();
        ((QueryWrapper)((QueryWrapper)query.eq((Object)"conn_id", (Object)connId)).eq((Object)"job_id", (Object)jobId)).eq((Object)"name", (Object)fileName);
        return (FileMapping)this.mapper.selectOne((Wrapper)query);
    }

    public List<FileMapping> listAll() {
        return this.mapper.selectList(null);
    }

    public IPage<FileMapping> list(int connId, int jobId, int pageNo, int pageSize) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"conn_id", (Object)connId);
        query.eq((Object)"job_id", (Object)jobId);
        query.eq((Object)"file_status", (Object)FileMappingStatus.COMPLETED.getValue());
        query.orderByDesc((Object)"create_time");
        Page page = new Page((long)pageNo, (long)pageSize);
        return this.mapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void save(FileMapping mapping) {
        if (this.mapper.insert(mapping) != 1) {
            throw new InternalException("entity.insert.failed", mapping);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(FileMapping mapping) {
        if (this.mapper.updateById(mapping) != 1) {
            throw new InternalException("entity.update.failed", mapping);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(int id) {
        if (this.mapper.deleteById(Integer.valueOf(id)) != 1) {
            throw new InternalException("entity.delete.failed", id);
        }
    }

    public String generateFileToken(String fileName) {
        return HubbleUtil.md5(fileName) + "-" + HubbleUtil.nowTime().getEpochSecond();
    }

    public FileUploadResult uploadFile(MultipartFile srcFile, int index, String dirPath) {
        FileUploadResult result = new FileUploadResult();
        String partName = srcFile.getOriginalFilename();
        result.setName(partName);
        result.setSize(srcFile.getSize());
        File destFile = new File(dirPath, partName + "-" + index);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (destFile.exists()) {
            destFile.delete();
        }
        log.debug("Uploading file {} length {}", (Object)partName, (Object)srcFile.getSize());
        try {
            srcFile.transferTo(destFile.getAbsoluteFile());
            result.setStatus(FileUploadResult.Status.SUCCESS);
            log.debug("Uploaded file part {}-{}", (Object)partName, (Object)index);
        }
        catch (Exception e) {
            log.error("Failed to save upload file and insert file mapping record", (Throwable)e);
            result.setStatus(FileUploadResult.Status.FAILURE);
            result.setCause(e.getMessage());
        }
        return result;
    }

    public boolean tryMergePartFiles(String dirPath, int total) {
        File dir = new File(dirPath);
        File[] partFiles = dir.listFiles();
        if (partFiles == null) {
            throw new InternalException("The part files can't be null", new Object[0]);
        }
        if (partFiles.length != total) {
            return false;
        }
        File newFile = new File(dir.getPath() + ".all");
        File destFile = new File(dir.getPath());
        if (partFiles.length == 1) {
            try {
                FileUtils.moveFile((File)partFiles[0], (File)newFile);
            }
            catch (IOException e) {
                log.error("Failed to rename file from {} to {}", (Object)partFiles[0], (Object)newFile, (Object)e);
                throw new InternalException("load.upload.move-file.failed", (Throwable)e, new Object[0]);
            }
        }
        Arrays.sort(partFiles, (o1, o2) -> {
            String file1Idx = StringUtils.substringAfterLast((String)o1.getName(), (String)"-");
            String file2Idx = StringUtils.substringAfterLast((String)o2.getName(), (String)"-");
            Integer idx1 = Integer.valueOf(file1Idx);
            Integer idx2 = Integer.valueOf(file2Idx);
            return idx1.compareTo(idx2);
        });
        try (FileOutputStream os = new FileOutputStream(newFile, true);){
            for (int i = 0; i < partFiles.length; ++i) {
                File partFile = partFiles[i];
                try (FileInputStream is = new FileInputStream(partFile);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    continue;
                }
                catch (IOException e) {
                    log.error("Failed to copy file stream from {} to {}", (Object)partFile, (Object)newFile, (Object)e);
                    throw new InternalException("load.upload.merge-file.failed", (Throwable)e, new Object[0]);
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to copy all file-parts stream to {}", (Object)newFile, (Object)e);
            throw new InternalException("load.upload.merge-file.failed", (Throwable)e, new Object[0]);
        }
        try {
            FileUtils.forceDelete((File)dir);
        }
        catch (IOException e) {
            log.error("Failed to force delete file {}", (Object)dir, (Object)e);
            throw new InternalException("load.upload.delete-temp-dir.failed", (Throwable)e, new Object[0]);
        }
        if (!newFile.renameTo(destFile)) {
            throw new InternalException("load.upload.rename-file.failed", new Object[0]);
        }
        return true;
    }

    public void extractColumns(FileMapping mapping) {
        String[] columnValues;
        String[] columnNames;
        BufferedReader reader;
        File file = FileUtils.getFile((String[])new String[]{mapping.getPath()});
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new InternalException("The file '%s' is not found", file);
        }
        FileSetting setting = mapping.getFileSetting();
        String delimiter = setting.getDelimiter();
        Pattern pattern = Pattern.compile(setting.getSkippedLine());
        try {
            String line;
            while ((line = reader.readLine()) != null && pattern.matcher(line).matches()) {
            }
            Ex.check(line != null, "The file has no data line can treat as header", new Object[0]);
            String[] firstLine = StringUtils.split((String)line, (String)delimiter);
            if (setting.isHasHeader()) {
                columnNames = firstLine;
                line = reader.readLine();
                columnValues = StringUtil.split((String)line, (String)delimiter);
            } else {
                columnNames = new String[firstLine.length];
                for (int i = 1; i <= firstLine.length; ++i) {
                    columnNames[i - 1] = "col-" + i;
                }
                columnValues = firstLine;
            }
        }
        catch (IOException e) {
            throw new InternalException("Failed to read header and sample data from file '%s'", file);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        setting.setColumnNames(Arrays.asList(columnNames));
        setting.setColumnValues(Arrays.asList(columnValues));
    }

    public String moveToNextLevelDir(FileMapping mapping) {
        File currFile = new File(mapping.getPath());
        String destPath = Paths.get(currFile.getParentFile().getPath(), FILE_PREIFX + mapping.getId()).toString();
        File destDir = new File(destPath);
        try {
            FileUtils.moveFileToDirectory((File)currFile, (File)destDir, (boolean)true);
        }
        catch (IOException e) {
            this.remove(mapping.getId());
            throw new InternalException("Failed to move file to next level directory", new Object[0]);
        }
        return Paths.get(destPath, currFile.getName()).toString();
    }

    public void deleteDiskFile(FileMapping mapping) {
        File file = new File(mapping.getPath());
        if (file.isDirectory()) {
            log.info("Prepare to delete directory {}", (Object)file);
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new InternalException("Failed to delete directory corresponded to the file id %s, please delete it manually", (Throwable)e, mapping.getId());
            }
        }
        File parentDir = file.getParentFile();
        log.info("Prepare to delete directory {}", (Object)parentDir);
        try {
            FileUtils.forceDelete((File)parentDir);
        }
        catch (IOException e) {
            throw new InternalException("Failed to delete parent directory corresponded to the file id %s, please delete it manually", (Throwable)e, mapping.getId());
        }
    }

    @Async
    @Scheduled(fixedRate=600000L)
    public void deleteUnfinishedFile() {
        QueryWrapper query = Wrappers.query();
        query.in((Object)"file_status", new Object[]{FileMappingStatus.UPLOADING.getValue()});
        List mappings = this.mapper.selectList((Wrapper)query);
        long threshold = (Long)this.config.get(HubbleOptions.UPLOAD_FILE_MAX_TIME_CONSUMING) * 1000L;
        Date now = HubbleUtil.nowDate();
        for (FileMapping mapping : mappings) {
            Date updateTime = mapping.getUpdateTime();
            long duration = now.getTime() - updateTime.getTime();
            if (duration <= threshold) continue;
            String filePath = mapping.getPath();
            try {
                FileUtils.forceDelete((File)new File(filePath));
            }
            catch (IOException e) {
                log.warn("Failed to delete expired uploading file {}", (Object)filePath, (Object)e);
            }
            this.remove(mapping.getId());
            Iterator<Map.Entry<String, ReadWriteLock>> iter = this.uploadingTokenLocks.entrySet().iterator();
            iter.forEachRemaining(entry -> {
                String token = (String)entry.getKey();
                if (token.startsWith(mapping.getName())) {
                    iter.remove();
                }
            });
        }
    }
}

