/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.graph;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.graph.EdgeEntity;
import org.apache.hugegraph.entity.graph.VertexEntity;
import org.apache.hugegraph.entity.query.GraphView;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.PropertyKeyEntity;
import org.apache.hugegraph.entity.schema.SchemaLabelEntity;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.file.ListFormat;
import org.apache.hugegraph.loader.util.DataTypeUtil;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.service.schema.EdgeLabelService;
import org.apache.hugegraph.service.schema.PropertyKeyService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.constant.IdStrategy;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.util.Ex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GraphService {
    private static final Logger log = LogManager.getLogger(GraphService.class);
    @Autowired
    private HugeClientPoolService poolService;
    @Autowired
    private PropertyKeyService pkService;
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private EdgeLabelService elService;

    public HugeClient client(int connId) {
        return this.poolService.getOrCreate(connId);
    }

    public GraphView addVertex(int connId, VertexEntity entity) {
        HugeClient client = this.client(connId);
        Vertex vertex = this.buildVertex(connId, entity);
        vertex = client.graph().addVertex(vertex);
        return GraphView.builder().vertices((Collection<Vertex>)ImmutableSet.of((Object)vertex)).edges((Collection<Edge>)ImmutableSet.of()).build();
    }

    public Vertex updateVertex(int connId, VertexEntity entity) {
        HugeClient client = this.client(connId);
        GraphManager graph = client.graph();
        Vertex vertex = this.buildVertex(connId, entity);
        return graph.addVertex(vertex);
    }

    private Vertex buildVertex(int connId, VertexEntity entity) {
        Vertex vertex = new Vertex(entity.getLabel());
        VertexLabelEntity vl = this.vlService.get(entity.getLabel(), connId);
        if (vl.getIdStrategy().isCustomize()) {
            Object vid = this.convertVertexId(vl.getIdStrategy(), entity.getId());
            vertex.id(vid);
        }
        this.fillProperties(connId, vl, (GraphElement)vertex, entity.getProperties());
        return vertex;
    }

    public GraphView addEdge(int connId, EdgeEntity entity) {
        HugeClient client = this.client(connId);
        GraphManager graph = client.graph();
        EdgeHolder edgeHolder = this.buildEdge(connId, entity);
        Edge edge = graph.addEdge(edgeHolder.edge);
        Vertex source = edgeHolder.source;
        Vertex target = edgeHolder.target;
        return GraphView.builder().vertices((Collection<Vertex>)ImmutableSet.of((Object)source, (Object)target)).edges((Collection<Edge>)ImmutableSet.of((Object)edge)).build();
    }

    public Edge updateEdge(int connId, EdgeEntity entity) {
        HugeClient client = this.client(connId);
        GraphManager graph = client.graph();
        EdgeHolder edgeHolder = this.buildEdge(connId, entity);
        return graph.addEdge(edgeHolder.edge);
    }

    private EdgeHolder buildEdge(int connId, EdgeEntity entity) {
        HugeClient client = this.client(connId);
        GraphManager graph = client.graph();
        EdgeLabelEntity el = this.elService.get(entity.getLabel(), connId);
        VertexLabelEntity sourceVl = this.vlService.get(el.getSourceLabel(), connId);
        VertexLabelEntity targetVl = this.vlService.get(el.getTargetLabel(), connId);
        Object realSourceId = this.convertVertexId(sourceVl.getIdStrategy(), entity.getSourceId());
        Object realTargetId = this.convertVertexId(targetVl.getIdStrategy(), entity.getTargetId());
        Vertex sourceVertex = graph.getVertex(realSourceId);
        Vertex targetVertex = graph.getVertex(realTargetId);
        Ex.check(el.getSourceLabel().equals(sourceVertex.label()) && el.getTargetLabel().equals(targetVertex.label()), "graph.edge.link-unmatched-vertex", entity.getLabel(), el.getSourceLabel(), el.getTargetLabel(), sourceVertex.label(), targetVertex.label());
        Edge edge = new Edge(entity.getLabel());
        edge.source(sourceVertex);
        edge.target(targetVertex);
        this.fillProperties(connId, el, (GraphElement)edge, entity.getProperties());
        return new EdgeHolder(edge, sourceVertex, targetVertex);
    }

    private Object convertVertexId(IdStrategy idStrategy, String rawId) {
        if (idStrategy.isCustomizeString() || idStrategy.isPrimaryKey()) {
            return rawId;
        }
        if (idStrategy.isCustomizeNumber()) {
            return DataTypeUtil.parseNumber((String)"id", (Object)rawId);
        }
        assert (idStrategy.isCustomizeUuid());
        return DataTypeUtil.parseUUID((String)"id", (Object)rawId);
    }

    private void fillProperties(int connId, SchemaLabelEntity schema, GraphElement element, Map<String, Object> properties) {
        HugeClient client = this.client(connId);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value;
            String key = entry.getKey();
            Object rawValue = entry.getValue();
            if (schema.getNullableProps().contains(key) && rawValue instanceof String && StringUtils.isEmpty((CharSequence)((String)rawValue))) continue;
            PropertyKeyEntity pkEntity = this.pkService.get(key, connId);
            PropertyKey propertyKey = PropertyKeyService.convert(pkEntity, client);
            assert (propertyKey != null);
            try {
                FileSource source = new FileSource();
                ListFormat listFormat = new ListFormat("", "", ",");
                source.listFormat(listFormat);
                value = DataTypeUtil.convert((Object)rawValue, (PropertyKey)propertyKey, (InputSource)source);
            }
            catch (IllegalArgumentException e) {
                throw new ExternalException("graph.property.convert.failed", (Throwable)e, key, rawValue);
            }
            element.property(key, value);
        }
    }

    private static class EdgeHolder {
        private Edge edge;
        private Vertex source;
        private Vertex target;

        public EdgeHolder(Edge edge, Vertex source, Vertex target) {
            this.edge = edge;
            this.source = source;
            this.target = target;
        }
    }
}

