/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.handler;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.service.license.LicenseService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class CustomInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LogManager.getLogger(CustomInterceptor.class);
    @Autowired
    private LicenseService licenseService;
    private static final Pattern CHECK_API_PATTERN = Pattern.compile(".*/graph-connections/\\d+/.+");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String url = request.getRequestURI();
        if (!CHECK_API_PATTERN.matcher(url).matches()) {
            return true;
        }
        String connIdValue = StringUtils.substringBetween((String)url, (String)"/graph-connections/", (String)"/");
        if (StringUtils.isEmpty((CharSequence)connIdValue)) {
            throw new InternalException("Not found conn id in url", new Object[0]);
        }
        return true;
    }
}

