/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.load;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.entity.load.ElementMapping;

public class EdgeMapping
extends ElementMapping {
    @MergeProperty
    @JsonProperty(value="source_fields")
    private List<String> sourceFields;
    @MergeProperty
    @JsonProperty(value="target_fields")
    private List<String> targetFields;

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof EdgeMapping)) {
            return false;
        }
        EdgeMapping other = (EdgeMapping)object;
        return this.getId().equals(other.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public static EdgeMappingBuilder builder() {
        return new EdgeMappingBuilder();
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public List<String> getTargetFields() {
        return this.targetFields;
    }

    public EdgeMapping() {
    }

    public EdgeMapping(List<String> sourceFields, List<String> targetFields) {
        this.sourceFields = sourceFields;
        this.targetFields = targetFields;
    }

    public static class EdgeMappingBuilder {
        private List<String> sourceFields;
        private List<String> targetFields;

        EdgeMappingBuilder() {
        }

        @JsonProperty(value="source_fields")
        public EdgeMappingBuilder sourceFields(List<String> sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        @JsonProperty(value="target_fields")
        public EdgeMappingBuilder targetFields(List<String> targetFields) {
            this.targetFields = targetFields;
            return this;
        }

        public EdgeMapping build() {
            return new EdgeMapping(this.sourceFields, this.targetFields);
        }

        public String toString() {
            return "EdgeMapping.EdgeMappingBuilder(sourceFields=" + this.sourceFields + ", targetFields=" + this.targetFields + ")";
        }
    }
}

