/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller;

import java.util.List;
import org.apache.hugegraph.common.Identifiable;
import org.apache.hugegraph.common.Mergeable;
import org.apache.hugegraph.util.EntityUtil;
import org.apache.hugegraph.util.Ex;
import org.springframework.util.StringUtils;

public abstract class BaseController {
    public static final String ORDER_ASC = "asc";
    public static final String ORDER_DESC = "desc";

    public void checkIdSameAsBody(Object id, Identifiable newEntity) {
        Ex.check(newEntity.getId() != null, () -> id.equals(newEntity.getId()), "common.param.path-id-should-same-as-body", id, newEntity.getId());
    }

    public void checkParamsNotEmpty(String name, String value, boolean creating) {
        if (creating) {
            Ex.check(!StringUtils.isEmpty((Object)value), "common.param.cannot-be-null-or-empty", name);
        } else {
            Ex.check(value == null || !value.isEmpty(), "common.param.cannot-be-empty", name);
        }
    }

    public void checkParamsNotEmpty(String name, List<?> values) {
        Ex.check(values != null && !values.isEmpty(), "common.param.cannot-be-null-or-empty", name);
    }

    public <T extends Mergeable> T mergeEntity(T oldEntity, T newEntity) {
        return EntityUtil.merge(oldEntity, newEntity);
    }
}

