/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Map;
import org.apache.hugegraph.common.Response;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@JsonComponent
public class JacksonConfig {
    @Bean
    public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper mapper = builder.createXmlMapper(false).build();
        SimpleModule module = new SimpleModule();
        mapper.registerModule((Module)module);
        return mapper;
    }

    private static void writeIdField(String fieldName, Object id, JsonGenerator generator) throws IOException {
        generator.writeStringField(fieldName, id.toString());
    }

    private static void writePropertiesField(Map<String, Object> properties, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeFieldName("properties");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            generator.writeFieldName(key);
            if (value != null) {
                if (value instanceof Long) {
                    generator.writeString(String.valueOf(value));
                    continue;
                }
                JsonSerializer serializer = provider.findValueSerializer(value.getClass());
                serializer.serialize(value, generator, provider);
                continue;
            }
            generator.writeNull();
        }
        generator.writeEndObject();
    }

    public static class EdgeSerializer
    extends JsonSerializer<Edge> {
        public void serialize(Edge edge, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (edge.id() != null) {
                JacksonConfig.writeIdField("id", edge.id(), generator);
            }
            generator.writeStringField("label", edge.label());
            JacksonConfig.writeIdField("source", edge.sourceId(), generator);
            JacksonConfig.writeIdField("target", edge.targetId(), generator);
            JacksonConfig.writePropertiesField(edge.properties(), generator, provider);
            generator.writeEndObject();
        }
    }

    public static class VertexSerializer
    extends JsonSerializer<Vertex> {
        public void serialize(Vertex vertex, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            JacksonConfig.writeIdField("id", vertex.id(), generator);
            generator.writeStringField("label", vertex.label());
            JacksonConfig.writePropertiesField(vertex.properties(), generator, provider);
            generator.writeEndObject();
        }
    }

    public static class ResponseSerailizer
    extends JsonSerializer<Response> {
        public void serialize(Response response, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("status", response.getStatus());
            generator.writeObjectField("data", response.getData());
            generator.writeObjectField("message", (Object)response.getMessage());
            Throwable cause = response.getCause();
            if (cause != null) {
                generator.writeStringField("cause", cause.toString());
            } else {
                generator.writeStringField("cause", null);
            }
            generator.writeEndObject();
        }
    }
}

