/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.function.Function;
import org.apache.hugegraph.util.E;

public final class NumericUtil {
    private static final long FULL_LONG = Long.MIN_VALUE;
    private static final int FULL_INT = Integer.MIN_VALUE;
    private static final byte FULL_BYTE = -128;

    private NumericUtil() {
    }

    public static long doubleToSortableLong(double value) {
        return NumericUtil.sortableDoubleBits(Double.doubleToLongBits(value));
    }

    public static double sortableLongToDouble(long value) {
        return Double.longBitsToDouble(NumericUtil.sortableDoubleBits(value));
    }

    public static int floatToSortableInt(float value) {
        return NumericUtil.sortableFloatBits(Float.floatToIntBits(value));
    }

    public static float sortableIntToFloat(int value) {
        return Float.intBitsToFloat(NumericUtil.sortableFloatBits(value));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static long numberToSortableLong(Number number) {
        if (number instanceof Double) {
            return NumericUtil.doubleToSortableLong(number.doubleValue());
        }
        if (number instanceof Float) {
            return NumericUtil.floatToSortableInt(number.floatValue());
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return number.longValue();
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            boolean intNumber = bd.stripTrailingZeros().scale() <= 0;
            return intNumber ? bd.longValueExact() : NumericUtil.doubleToSortableLong(bd.doubleValue());
        }
        throw NumericUtil.unsupportedNumberType(number);
    }

    public static Number sortableLongToNumber(long value, Class<?> clazz) {
        assert (NumericUtil.isNumber(clazz));
        if (clazz == Double.class) {
            return NumericUtil.sortableLongToDouble(value);
        }
        if (clazz == Float.class) {
            return Float.valueOf(NumericUtil.sortableIntToFloat((int)value));
        }
        if (clazz == Long.class) {
            return value;
        }
        if (clazz == Integer.class) {
            return (int)value;
        }
        if (clazz == Short.class) {
            return (short)value;
        }
        if (clazz == Byte.class) {
            return (byte)value;
        }
        throw NumericUtil.unsupportedNumberType(clazz);
    }

    public static byte[] numberToSortableBytes(Number number) {
        if (number instanceof Long) {
            return NumericUtil.longToSortableBytes(number.longValue());
        }
        if (number instanceof Double) {
            long value = NumericUtil.doubleToSortableLong(number.doubleValue());
            return NumericUtil.longToSortableBytes(value);
        }
        if (number instanceof Float) {
            int value = NumericUtil.floatToSortableInt(number.floatValue());
            return NumericUtil.intToSortableBytes(value);
        }
        if (number instanceof Integer || number instanceof Short) {
            return NumericUtil.intToSortableBytes(number.intValue());
        }
        if (number instanceof Byte) {
            return NumericUtil.byteToSortableBytes(number.byteValue());
        }
        throw NumericUtil.unsupportedNumberType(number);
    }

    public static Number sortableBytesToNumber(byte[] bytes, Class<?> clazz) {
        assert (NumericUtil.isNumber(clazz));
        if (clazz == Long.class) {
            return NumericUtil.sortableBytesToLong(bytes);
        }
        if (clazz == Double.class) {
            return NumericUtil.sortableLongToDouble(NumericUtil.sortableBytesToLong(bytes));
        }
        if (clazz == Float.class) {
            return Float.valueOf(NumericUtil.sortableIntToFloat(NumericUtil.sortableBytesToInt(bytes)));
        }
        if (clazz == Integer.class) {
            return NumericUtil.sortableBytesToInt(bytes);
        }
        if (clazz == Short.class) {
            return (short)NumericUtil.sortableBytesToInt(bytes);
        }
        if (clazz == Byte.class) {
            return NumericUtil.sortableBytesToByte(bytes);
        }
        throw NumericUtil.unsupportedNumberType(clazz);
    }

    public static Number minValueOf(Class<?> clazz) {
        E.checkArgumentNotNull(clazz, "The clazz can't be null", new Object[0]);
        if (Long.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return Long.MIN_VALUE;
        }
        if (Integer.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
            return Integer.MIN_VALUE;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (byte)-128;
        }
        throw NumericUtil.unsupportedNumberType(clazz);
    }

    public static Number maxValueOf(Class<?> clazz) {
        E.checkArgumentNotNull(clazz, "The clazz can't be null", new Object[0]);
        if (Long.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return Long.MAX_VALUE;
        }
        if (Integer.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz)) {
            return Integer.MAX_VALUE;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (byte)127;
        }
        throw NumericUtil.unsupportedNumberType(clazz);
    }

    public static byte[] longToSortableBytes(long value) {
        return NumericUtil.longToBytes(value + Long.MIN_VALUE);
    }

    public static long sortableBytesToLong(byte[] bytes) {
        return NumericUtil.bytesToLong(bytes) - Long.MIN_VALUE;
    }

    public static byte[] intToSortableBytes(int value) {
        return NumericUtil.intToBytes(value + Integer.MIN_VALUE);
    }

    public static int sortableBytesToInt(byte[] bytes) {
        return NumericUtil.bytesToInt(bytes) - Integer.MIN_VALUE;
    }

    public static byte[] byteToSortableBytes(byte value) {
        value = (byte)(value - 128);
        return new byte[]{value};
    }

    public static byte sortableBytesToByte(byte[] bytes) {
        assert (bytes.length == 1);
        byte value = bytes[0];
        value = (byte)(value + 128);
        return value;
    }

    public static byte[] longToBytes(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        assert (bytes.length == 8);
        return ByteBuffer.wrap(bytes).getLong();
    }

    public static byte[] intToBytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    public static int bytesToInt(byte[] bytes) {
        assert (bytes.length == 4);
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        return NumericUtil.isNumber(value.getClass());
    }

    public static boolean isNumber(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static Number convertToNumber(Object value) {
        if (value == null) {
            return null;
        }
        Number number = NumericUtil.isNumber(value) ? (Number)((Number)value) : (Number)(value instanceof Date ? Long.valueOf(((Date)value).getTime()) : new BigDecimal(value.toString()));
        return number;
    }

    public static int compareNumber(Object first, Number second) {
        if (first == null) {
            E.checkArgument(first != null, "The first parameter can't be null", new Object[0]);
        }
        if (second == null) {
            E.checkArgument(second != null, "The second parameter can't be null", new Object[0]);
        }
        if (first instanceof Number && first instanceof Comparable && first.getClass().equals(second.getClass())) {
            Comparable cmpFirst = (Comparable)first;
            return cmpFirst.compareTo(second);
        }
        Function<Object, BigDecimal> toBig = number -> {
            try {
                return new BigDecimal(number.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Can't compare between '%s' and '%s', they must be numbers", first, second));
            }
        };
        BigDecimal n1 = toBig.apply(first);
        BigDecimal n2 = toBig.apply(second);
        return n1.compareTo(n2);
    }

    private static IllegalArgumentException unsupportedNumberType(Class<?> c) {
        return new IllegalArgumentException(String.format("Unsupported number type: %s", c.getSimpleName()));
    }

    private static IllegalArgumentException unsupportedNumberType(Number num) {
        return new IllegalArgumentException(String.format("Unsupported number type: %s(%s)", num.getClass().getSimpleName(), num));
    }
}

