/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.util.E;

public final class CommonUtil {
    public static final String PREFIX = "https://github.com/apache/incubator-hugegraph-doc/raw/binary/dist/toolchain/";

    public static void checkMapClass(Object object, Class<?> kClass, Class<?> vClass) {
        E.checkArgumentNotNull((Object)object, (String)"The object can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)(object instanceof Map), (String)"The object must be instance of Map, but got '%s'(%s)", (Object[])new Object[]{object, object.getClass()});
        E.checkArgumentNotNull(kClass, (String)"The key class can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull(vClass, (String)"The value class can't be null", (Object[])new Object[0]);
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            E.checkState((boolean)kClass.isAssignableFrom(key.getClass()), (String)"The map key must be instance of %s, but got '%s'(%s)", (Object[])new Object[]{kClass, key, key.getClass()});
            E.checkState((boolean)vClass.isAssignableFrom(value.getClass()), (String)"The map value must be instance of %s, but got '%s'(%s)", (Object[])new Object[]{vClass, value, value.getClass()});
        }
    }

    public static void downloadFileByUrl(String url, String destPath) {
        int connectTimeout = 5000;
        int readTimeout = 5000;
        try {
            FileUtils.copyURLToFile((URL)new URL(url), (File)new File(destPath), (int)connectTimeout, (int)readTimeout);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download file, please check the network", e);
        }
    }
}

