/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class SubStructObjectInspector
extends StructObjectInspector {
    protected StructObjectInspector baseOI;
    protected int startCol;
    protected int numCols;
    protected List<StructField> fields;

    public SubStructObjectInspector(StructObjectInspector baseOI, int startCol, int numCols) {
        this.baseOI = baseOI;
        this.startCol = startCol;
        this.numCols = numCols;
        List<? extends StructField> baseFields = baseOI.getAllStructFieldRefs();
        assert (startCol < baseFields.size() && startCol + numCols < baseFields.size());
        this.fields = new ArrayList<StructField>(numCols);
        this.fields.addAll(baseOI.getAllStructFieldRefs().subList(startCol, startCol + numCols));
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName(this);
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        return this.baseOI.getStructFieldData(data, fieldRef);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        return this.baseOI.getStructFieldsDataAsList(data).subList(this.startCol, this.startCol + this.numCols);
    }
}

