/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.auth;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.structure.auth.AuthElement;
import org.apache.hugegraph.structure.auth.HugePermission;
import org.apache.hugegraph.structure.auth.HugeResource;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.util.JsonUtil;

public class User
extends AuthElement {
    @JsonProperty(value="user_name")
    private String name;
    @JsonProperty(value="user_password")
    private String password;
    @JsonProperty(value="user_phone")
    private String phone;
    @JsonProperty(value="user_email")
    private String email;
    @JsonProperty(value="user_avatar")
    private String avatar;
    @JsonProperty(value="user_description")
    private String description;
    @JsonProperty(value="user_create")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    protected Date create;
    @JsonProperty(value="user_update")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    protected Date update;
    @JsonProperty(value="user_creator")
    protected String creator;

    @Override
    public String type() {
        return HugeType.USER.string();
    }

    @Override
    public Date createTime() {
        return this.create;
    }

    @Override
    public Date updateTime() {
        return this.update;
    }

    @Override
    public String creator() {
        return this.creator;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String password() {
        return this.password;
    }

    public void password(String password) {
        this.password = password;
    }

    public String phone() {
        return this.phone;
    }

    public void phone(String phone) {
        this.phone = phone;
    }

    public String email() {
        return this.email;
    }

    public void email(String email) {
        this.email = email;
    }

    public String avatar() {
        return this.avatar;
    }

    public void avatar(String avatar) {
        this.avatar = avatar;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public static class UserRole {
        @JsonProperty(value="roles")
        private Map<String, Map<HugePermission, List<HugeResource>>> roles;

        public Map<String, Map<HugePermission, List<HugeResource>>> roles() {
            return Collections.unmodifiableMap(this.roles);
        }

        public String toString() {
            return JsonUtil.toJson(this);
        }
    }
}

