/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import java.io.Closeable;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.driver.AuthManager;
import org.apache.hugegraph.driver.CypherManager;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.driver.GraphsManager;
import org.apache.hugegraph.driver.GremlinManager;
import org.apache.hugegraph.driver.HugeClientBuilder;
import org.apache.hugegraph.driver.JobManager;
import org.apache.hugegraph.driver.MetricsManager;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.driver.TaskManager;
import org.apache.hugegraph.driver.TraverserManager;
import org.apache.hugegraph.driver.VariablesManager;
import org.apache.hugegraph.driver.VersionManager;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.util.VersionUtil;
import org.apache.hugegraph.version.ClientVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HugeClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private final RestClient client;
    private final boolean borrowedClient;
    private VersionManager version;
    private GraphsManager graphs;
    private SchemaManager schema;
    private GraphManager graph;
    private GremlinManager gremlin;
    private CypherManager cypher;
    private TraverserManager traverser;
    private VariablesManager variable;
    private JobManager job;
    private TaskManager task;
    private AuthManager auth;
    private MetricsManager metrics;

    public HugeClient(HugeClientBuilder builder) {
        this.borrowedClient = false;
        try {
            this.client = new RestClient(builder.url(), builder.username(), builder.password(), builder.timeout(), builder.maxConns(), builder.maxConnsPerRoute(), builder.trustStoreFile(), builder.trustStorePassword());
        }
        catch (Exception e) {
            LOG.warn("Failed to create RestClient instance", (Throwable)e);
            throw new ClientException("Failed to connect url '%s'", new Object[]{builder.url()});
        }
        try {
            this.initManagers(this.client, builder.graph());
        }
        catch (Throwable e) {
            this.client.close();
            throw e;
        }
    }

    public HugeClient(HugeClient client, String graph) {
        this.borrowedClient = true;
        this.client = client.client;
        this.initManagers(this.client, graph);
    }

    public static HugeClientBuilder builder(String url, String graph) {
        return new HugeClientBuilder(url, graph);
    }

    @Override
    public void close() {
        if (!this.borrowedClient) {
            this.client.close();
        }
    }

    private void initManagers(RestClient client, String graph) {
        assert (client != null);
        this.version = new VersionManager(client);
        this.checkServerApiVersion();
        this.graphs = new GraphsManager(client);
        this.schema = new SchemaManager(client, graph);
        this.graph = new GraphManager(client, graph);
        this.gremlin = new GremlinManager(client, graph, this.graph);
        this.cypher = new CypherManager(client, graph, this.graph);
        this.traverser = new TraverserManager(client, this.graph);
        this.variable = new VariablesManager(client, graph);
        this.job = new JobManager(client, graph);
        this.task = new TaskManager(client, graph);
        this.auth = new AuthManager(client, graph);
        this.metrics = new MetricsManager(client);
    }

    private void checkServerApiVersion() {
        VersionUtil.Version apiVersion = VersionUtil.Version.of((String)this.version.getApiVersion());
        VersionUtil.check((VersionUtil.Version)apiVersion, (String)"0.38", (String)"0.81", (String)"hugegraph-api in server");
        this.client.apiVersion(apiVersion);
    }

    public GraphsManager graphs() {
        return this.graphs;
    }

    public SchemaManager schema() {
        return this.schema;
    }

    public GraphManager graph() {
        return this.graph;
    }

    public GremlinManager gremlin() {
        return this.gremlin;
    }

    public CypherManager cypher() {
        return this.cypher;
    }

    public TraverserManager traverser() {
        return this.traverser;
    }

    public VariablesManager variables() {
        return this.variable;
    }

    public JobManager job() {
        return this.job;
    }

    public TaskManager task() {
        return this.task;
    }

    public AuthManager auth() {
        return this.auth;
    }

    public MetricsManager metrics() {
        return this.metrics;
    }

    public void setAuthContext(String auth) {
        this.client.setAuthContext(auth);
    }

    public String getAuthContext() {
        return this.client.getAuthContext();
    }

    public void resetAuthContext() {
        this.client.resetAuthContext();
    }

    static {
        ClientVersion.check();
    }
}

