/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.driver.AuthManager;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.driver.GraphsManager;
import org.apache.hugegraph.driver.GremlinManager;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.driver.TaskManager;
import org.apache.hugegraph.driver.TraverserManager;
import org.apache.hugegraph.util.E;

public class ToolClient {
    private static final String DEFAULT_TRUST_STORE_FILE = "conf/hugegraph.truststore";
    private static final String DEFAULT_TRUST_STORE_PASSWORD = "hugegraph";
    private final HugeClient client;
    private final ObjectMapper mapper;

    public ToolClient(ConnectionInfo info) {
        String trustStorePassword;
        String trustStoreFile;
        if (info.username == null) {
            info.username = "";
            info.password = "";
        }
        if (info.url.startsWith("https")) {
            if (info.trustStoreFile == null || info.trustStoreFile.isEmpty()) {
                trustStoreFile = Paths.get(ToolClient.homePath(), DEFAULT_TRUST_STORE_FILE).toString();
                trustStorePassword = DEFAULT_TRUST_STORE_PASSWORD;
            } else {
                E.checkArgumentNotNull((Object)info.trustStorePassword, (String)"The trust store password can't be null when use https", (Object[])new Object[0]);
                trustStoreFile = info.trustStoreFile;
                trustStorePassword = info.trustStorePassword;
            }
        } else {
            assert (info.url.startsWith("http"));
            E.checkArgument((info.trustStoreFile == null ? 1 : 0) != 0, (String)"Can't set --trust-store-file when use http", (Object[])new Object[0]);
            E.checkArgument((info.trustStorePassword == null ? 1 : 0) != 0, (String)"Can't set --trust-store-password when use http", (Object[])new Object[0]);
            trustStoreFile = info.trustStoreFile;
            trustStorePassword = info.trustStorePassword;
        }
        this.client = HugeClient.builder((String)info.url, (String)info.graph).configUser(info.username, info.password).configTimeout(info.timeout.intValue()).configSSL(trustStoreFile, trustStorePassword).build();
        this.mapper = new ObjectMapper();
    }

    public TraverserManager traverser() {
        return this.client.traverser();
    }

    public GraphManager graph() {
        return this.client.graph();
    }

    public SchemaManager schema() {
        return this.client.schema();
    }

    public GraphsManager graphs() {
        return this.client.graphs();
    }

    public TaskManager tasks() {
        return this.client.task();
    }

    public GremlinManager gremlin() {
        return this.client.gremlin();
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public static String homePath() {
        String homePath = System.getProperty("tools.home.path");
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)homePath), (String)"The system property 'tools.home.path' can't be empty when enable https protocol", (Object[])new Object[0]);
        return homePath;
    }

    public AuthManager authManager() {
        return this.client.auth();
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public static class ConnectionInfo {
        private final String url;
        private final String graph;
        private String username;
        private String password;
        private final Integer timeout;
        private final String trustStoreFile;
        private final String trustStorePassword;

        public ConnectionInfo(String url, String graph, String username, String password, Integer timeout, String trustStoreFile, String trustStorePassword) {
            this.url = url;
            this.graph = graph;
            this.username = username;
            this.password = password;
            this.timeout = timeout;
            this.trustStoreFile = trustStoreFile;
            this.trustStorePassword = trustStorePassword;
        }
    }
}

