/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.KeyValue;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.JoinedRow;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.OffsetRow;

public class KeyValueWithLevelNoReusingSerializer
extends ObjectSerializer<KeyValue> {
    private static final long serialVersionUID = 1L;
    private final int keyArity;
    private final int valueArity;

    public KeyValueWithLevelNoReusingSerializer(RowType keyType, RowType valueType) {
        super(KeyValue.schemaWithLevel(keyType, valueType));
        this.keyArity = keyType.getFieldCount();
        this.valueArity = valueType.getFieldCount();
    }

    @Override
    public InternalRow toRow(KeyValue kv) {
        GenericRow meta = GenericRow.of(kv.sequenceNumber(), kv.valueKind().toByteValue());
        return JoinedRow.join(JoinedRow.join(JoinedRow.join(kv.key(), meta), kv.value()), GenericRow.of(kv.level()));
    }

    @Override
    public KeyValue fromRow(InternalRow row) {
        return new KeyValue().replace(new OffsetRow(this.keyArity, 0).replace(row), row.getLong(this.keyArity), RowKind.fromByteValue(row.getByte(this.keyArity + 1)), new OffsetRow(this.valueArity, this.keyArity + 2).replace(row)).setLevel(row.getInt(this.keyArity + 2 + this.valueArity));
    }
}

