/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.responses;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.rest.RESTResponse;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.utils.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigResponse
implements RESTResponse {
    private static final String FIELD_DEFAULTS = "defaults";
    private static final String FIELD_OVERRIDES = "overrides";
    @JsonProperty(value="defaults")
    private final Map<String, String> defaults;
    @JsonProperty(value="overrides")
    private final Map<String, String> overrides;

    @JsonCreator
    public ConfigResponse(@JsonProperty(value="defaults") Map<String, String> defaults, @JsonProperty(value="overrides") Map<String, String> overrides) {
        this.defaults = defaults;
        this.overrides = overrides;
    }

    public Map<String, String> merge(Map<String, String> clientProperties) {
        Preconditions.checkNotNull(clientProperties, "Cannot merge client properties with server-provided properties. Invalid client configuration: null");
        HashMap<String, String> merged = this.defaults != null ? Maps.newHashMap(this.defaults) : Maps.newHashMap();
        merged.putAll(clientProperties);
        if (this.overrides != null) {
            merged.putAll(this.overrides);
        }
        return ImmutableMap.copyOf(Maps.filterValues(merged, Objects::nonNull));
    }

    @JsonGetter(value="defaults")
    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    @JsonGetter(value="overrides")
    public Map<String, String> getOverrides() {
        return this.overrides;
    }
}

