/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bitmap;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.FileIndexWriter;
import org.apache.paimon.fileindex.FileIndexer;
import org.apache.paimon.fileindex.bitmap.BitmapFileIndexMeta;
import org.apache.paimon.fileindex.bitmap.BitmapFileIndexMetaV2;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.fileindex.bitmap.BitmapTypeVisitor;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.RoaringBitmap32;

public class BitmapFileIndex
implements FileIndexer {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final String VERSION = "version";
    public static final String INDEX_BLOCK_SIZE = "index-block-size";
    private final DataType dataType;
    private final Options options;

    public BitmapFileIndex(DataType dataType, Options options) {
        this.dataType = dataType;
        this.options = options;
    }

    @Override
    public FileIndexWriter createWriter() {
        return new Writer(this.dataType, this.options);
    }

    @Override
    public FileIndexReader createReader(SeekableInputStream seekableInputStream, int start, int length) {
        try {
            return new Reader(seekableInputStream, start, this.options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Function<Object, Object> getValueMapper(DataType dataType) {
        return dataType.accept(new BitmapTypeVisitor<Function<Object, Object>>(){

            @Override
            public Function<Object, Object> visitBinaryString() {
                return o -> {
                    if (o instanceof BinaryString) {
                        return ((BinaryString)o).copy();
                    }
                    return o;
                };
            }

            @Override
            public Function<Object, Object> visitByte() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visitShort() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visitInt() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visitLong() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visitFloat() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visitDouble() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visitBoolean() {
                return Function.identity();
            }

            @Override
            public Function<Object, Object> visit(TimestampType timestampType) {
                return this.getTimeStampMapper(timestampType.getPrecision());
            }

            @Override
            public Function<Object, Object> visit(LocalZonedTimestampType localZonedTimestampType) {
                return this.getTimeStampMapper(localZonedTimestampType.getPrecision());
            }

            private Function<Object, Object> getTimeStampMapper(int precision) {
                return o -> {
                    if (o == null) {
                        return null;
                    }
                    if (precision <= 3) {
                        return ((Timestamp)o).getMillisecond();
                    }
                    return ((Timestamp)o).toMicros();
                };
            }
        });
    }

    private static class Reader
    extends FileIndexReader {
        private final SeekableInputStream seekableInputStream;
        private final int headStart;
        private final Map<Object, RoaringBitmap32> bitmaps = new LinkedHashMap<Object, RoaringBitmap32>();
        private BitmapFileIndexMeta bitmapFileIndexMeta;
        private Function<Object, Object> valueMapper;
        private final Options options;

        public Reader(SeekableInputStream seekableInputStream, int start, Options options) {
            this.seekableInputStream = seekableInputStream;
            this.headStart = start;
            this.options = options;
        }

        @Override
        public FileIndexResult visitEqual(FieldRef fieldRef, Object literal) {
            return this.visitIn(fieldRef, (List)Collections.singletonList(literal));
        }

        @Override
        public FileIndexResult visitNotEqual(FieldRef fieldRef, Object literal) {
            return this.visitNotIn(fieldRef, (List)Collections.singletonList(literal));
        }

        @Override
        public FileIndexResult visitIn(FieldRef fieldRef, List<Object> literals) {
            return new BitmapIndexResult(() -> {
                this.readInternalMeta(fieldRef.type());
                return this.getInListResultBitmap(literals);
            });
        }

        @Override
        public FileIndexResult visitNotIn(FieldRef fieldRef, List<Object> literals) {
            return new BitmapIndexResult(() -> {
                this.readInternalMeta(fieldRef.type());
                RoaringBitmap32 bitmap = this.getInListResultBitmap(literals);
                bitmap.flip(0L, this.bitmapFileIndexMeta.getRowCount());
                return bitmap;
            });
        }

        @Override
        public FileIndexResult visitIsNull(FieldRef fieldRef) {
            return this.visitIn(fieldRef, Collections.singletonList(null));
        }

        @Override
        public FileIndexResult visitIsNotNull(FieldRef fieldRef) {
            return this.visitNotIn(fieldRef, Collections.singletonList(null));
        }

        private RoaringBitmap32 getInListResultBitmap(List<Object> literals) {
            return RoaringBitmap32.or(literals.stream().map(it -> this.bitmaps.computeIfAbsent(this.valueMapper.apply(it), this::readBitmap)).iterator());
        }

        private RoaringBitmap32 readBitmap(Object bitmapId) {
            try {
                BitmapFileIndexMeta.Entry entry = this.bitmapFileIndexMeta.findEntry(bitmapId);
                if (entry == null) {
                    return new RoaringBitmap32();
                }
                int offset = entry.offset;
                if (offset < 0) {
                    return RoaringBitmap32.bitmapOf(-1 - offset);
                }
                this.seekableInputStream.seek(this.bitmapFileIndexMeta.getBodyStart() + (long)offset);
                RoaringBitmap32 bitmap = new RoaringBitmap32();
                int length = entry.length;
                if (length != -1) {
                    DataInputStream input = new DataInputStream(this.seekableInputStream);
                    byte[] bytes = new byte[length];
                    input.readFully(bytes);
                    bitmap.deserialize(ByteBuffer.wrap(bytes));
                    return bitmap;
                }
                bitmap.deserialize(new DataInputStream(this.seekableInputStream));
                return bitmap;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void readInternalMeta(DataType dataType) {
            if (this.bitmapFileIndexMeta == null) {
                this.valueMapper = BitmapFileIndex.getValueMapper(dataType);
                try {
                    this.seekableInputStream.seek(this.headStart);
                    int version = this.seekableInputStream.read();
                    if (version == 1) {
                        this.bitmapFileIndexMeta = new BitmapFileIndexMeta(dataType, this.options);
                        this.bitmapFileIndexMeta.deserialize(this.seekableInputStream);
                    } else if (version == 2) {
                        this.bitmapFileIndexMeta = new BitmapFileIndexMetaV2(dataType, this.options);
                        this.bitmapFileIndexMeta.deserialize(this.seekableInputStream);
                    } else if (version > 2) {
                        throw new RuntimeException(String.format("read index file fail, your plugin version is lower than %d", version));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class Writer
    extends FileIndexWriter {
        private final int version;
        private final DataType dataType;
        private final Function<Object, Object> valueMapper;
        private final Map<Object, RoaringBitmap32> id2bitmap = new HashMap<Object, RoaringBitmap32>();
        private final RoaringBitmap32 nullBitmap = new RoaringBitmap32();
        private int rowNumber;
        private final Options options;

        public Writer(DataType dataType, Options options) {
            this.version = options.getInteger(BitmapFileIndex.VERSION, 2);
            this.dataType = dataType;
            this.valueMapper = BitmapFileIndex.getValueMapper(dataType);
            this.options = options;
        }

        @Override
        public void write(Object key) {
            if (key == null) {
                this.nullBitmap.add(this.rowNumber++);
            } else {
                this.id2bitmap.computeIfAbsent(this.valueMapper.apply(key), k -> new RoaringBitmap32()).add(this.rowNumber++);
            }
        }

        @Override
        public byte[] serializedBytes() {
            try {
                BitmapFileIndexMeta bitmapFileIndexMeta;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(output);
                dos.writeByte(this.version);
                byte[] nullBitmapBytes = this.nullBitmap.serialize();
                Map<Object, byte[]> id2bitmapBytes = this.id2bitmap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((RoaringBitmap32)e.getValue()).serialize()));
                LinkedHashMap<Object, Integer> bitmapOffsets = new LinkedHashMap<Object, Integer>();
                LinkedList serializeBitmaps = new LinkedList();
                int[] offsetRef = new int[]{this.nullBitmap.isEmpty() || this.nullBitmap.getCardinality() == 1L ? 0 : nullBitmapBytes.length};
                this.id2bitmap.forEach((k, v) -> {
                    if (v.getCardinality() == 1L) {
                        bitmapOffsets.put(k, -1 - v.iterator().next());
                    } else {
                        byte[] bytes = (byte[])id2bitmapBytes.get(k);
                        serializeBitmaps.add(bytes);
                        bitmapOffsets.put(k, offsetRef[0]);
                        offsetRef[0] = offsetRef[0] + bytes.length;
                    }
                });
                if (this.version == 1) {
                    bitmapFileIndexMeta = new BitmapFileIndexMeta(this.dataType, this.options, this.rowNumber, this.id2bitmap.size(), !this.nullBitmap.isEmpty(), this.nullBitmap.getCardinality() == 1L ? -1 - this.nullBitmap.iterator().next() : 0, bitmapOffsets);
                } else if (this.version == 2) {
                    bitmapFileIndexMeta = new BitmapFileIndexMetaV2(this.dataType, this.options, this.rowNumber, this.id2bitmap.size(), !this.nullBitmap.isEmpty(), this.nullBitmap.getCardinality() == 1L ? -1 - this.nullBitmap.iterator().next() : 0, nullBitmapBytes.length, bitmapOffsets, offsetRef[0]);
                } else {
                    throw new RuntimeException("invalid version: " + this.version);
                }
                bitmapFileIndexMeta.serialize(dos);
                if (this.nullBitmap.getCardinality() > 1L) {
                    dos.write(nullBitmapBytes);
                }
                for (byte[] bytes : serializeBitmaps) {
                    dos.write(bytes);
                }
                return output.toByteArray();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

