/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerStatusPBImpl
extends ContainerStatus {
    YarnProtos.ContainerStatusProto proto = YarnProtos.ContainerStatusProto.getDefaultInstance();
    YarnProtos.ContainerStatusProto.Builder builder = null;
    boolean viaProto = false;
    private ContainerId containerId = null;

    public ContainerStatusPBImpl() {
        this.builder = YarnProtos.ContainerStatusProto.newBuilder();
    }

    public ContainerStatusPBImpl(YarnProtos.ContainerStatusProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.ContainerStatusProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerStatusPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerStatus: [");
        sb.append("ContainerId: ").append(this.getContainerId()).append(", ");
        sb.append("State: ").append((Object)this.getState()).append(", ");
        sb.append("Capability: ").append(this.getCapability()).append(", ");
        sb.append("Diagnostics: ").append(this.getDiagnostics()).append(", ");
        sb.append("ExitStatus: ").append(this.getExitStatus()).append(", ");
        sb.append("]");
        return sb.toString();
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null) {
            this.builder.setContainerId(this.convertToProtoFormat(this.containerId));
        }
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerStatusProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized ContainerState getState() {
        YarnProtos.ContainerStatusProtoOrBuilder p;
        YarnProtos.ContainerStatusProtoOrBuilder containerStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getState());
    }

    @Override
    public synchronized void setState(ContainerState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearState();
            return;
        }
        this.builder.setState(this.convertToProtoFormat(state));
    }

    @Override
    public synchronized ContainerId getContainerId() {
        YarnProtos.ContainerStatusProtoOrBuilder p;
        YarnProtos.ContainerStatusProtoOrBuilder containerStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerId != null) {
            return this.containerId;
        }
        if (!p.hasContainerId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getContainerId());
        return this.containerId;
    }

    @Override
    public synchronized void setContainerId(ContainerId containerId) {
        this.maybeInitBuilder();
        if (containerId == null) {
            this.builder.clearContainerId();
        }
        this.containerId = containerId;
    }

    @Override
    public synchronized int getExitStatus() {
        YarnProtos.ContainerStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getExitStatus();
    }

    @Override
    public synchronized void setExitStatus(int exitStatus) {
        this.maybeInitBuilder();
        this.builder.setExitStatus(exitStatus);
    }

    @Override
    public synchronized String getDiagnostics() {
        YarnProtos.ContainerStatusProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getDiagnostics();
    }

    @Override
    public synchronized void setDiagnostics(String diagnostics) {
        this.maybeInitBuilder();
        this.builder.setDiagnostics(diagnostics);
    }

    @Override
    public synchronized Resource getCapability() {
        YarnProtos.ContainerStatusProtoOrBuilder p;
        YarnProtos.ContainerStatusProtoOrBuilder containerStatusProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCapability()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getCapability());
    }

    @Override
    public synchronized void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
            return;
        }
        this.builder.setCapability(this.convertToProtoFormat(capability));
    }

    private YarnProtos.ContainerStateProto convertToProtoFormat(ContainerState e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    private ContainerState convertFromProtoFormat(YarnProtos.ContainerStateProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource e) {
        return ((ResourcePBImpl)e).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }
}

