/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.util.internal;

import java.util.ArrayList;
import java.util.Formatter;

public final class StringUtil {
    public static final String NEWLINE;
    private static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static String stripControlCharacters(Object value) {
        if (value == null) {
            return null;
        }
        return StringUtil.stripControlCharacters(value.toString());
    }

    public static String stripControlCharacters(String value) {
        int i;
        if (value == null) {
            return null;
        }
        boolean hasControlChars = false;
        for (int i2 = value.length() - 1; i2 >= 0; --i2) {
            if (!Character.isISOControl(value.charAt(i2))) continue;
            hasControlChars = true;
            break;
        }
        if (!hasControlChars) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length());
        for (i = 0; i < value.length() && Character.isISOControl(value.charAt(i)); ++i) {
        }
        boolean suppressingControlChars = false;
        while (i < value.length()) {
            if (Character.isISOControl(value.charAt(i))) {
                suppressingControlChars = true;
            } else {
                if (suppressingControlChars) {
                    suppressingControlChars = false;
                    buf.append(' ');
                }
                buf.append(value.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    public static String[] split(String value, char delim) {
        int i;
        int end = value.length();
        ArrayList<String> res = new ArrayList<String>();
        int start = 0;
        for (i = 0; i < end; ++i) {
            if (value.charAt(i) != delim) continue;
            if (start == i) {
                res.add(EMPTY_STRING);
            } else {
                res.add(value.substring(start, i));
            }
            start = i + 1;
        }
        if (start == 0) {
            res.add(value);
        } else if (start != end) {
            res.add(value.substring(start, end));
        } else {
            for (i = res.size() - 1; i >= 0 && ((String)res.get(i)).length() == 0; --i) {
                res.remove(i);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    static {
        String newLine;
        try {
            newLine = new Formatter().format("%n", new Object[0]).toString();
        }
        catch (Exception e) {
            newLine = "\n";
        }
        NEWLINE = newLine;
    }
}

