/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class FastSaslServerFactory
implements SaslServerFactory {
    private final Map<String, List<SaslServerFactory>> factoryCache = new HashMap<String, List<SaslServerFactory>>();

    public FastSaslServerFactory(Map<String, ?> props) {
        Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
        while (factories.hasMoreElements()) {
            SaslServerFactory factory2 = factories.nextElement();
            for (String mech : factory2.getMechanismNames(props)) {
                if (!this.factoryCache.containsKey(mech)) {
                    this.factoryCache.put(mech, new ArrayList());
                }
                this.factoryCache.get(mech).add(factory2);
            }
        }
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslServer saslServer;
        block1: {
            SaslServerFactory factory2;
            saslServer = null;
            List<SaslServerFactory> factories = this.factoryCache.get(mechanism);
            if (factories == null) break block1;
            Iterator<SaslServerFactory> iterator2 = factories.iterator();
            while (iterator2.hasNext() && (saslServer = (factory2 = iterator2.next()).createSaslServer(mechanism, protocol, serverName, props, cbh)) == null) {
            }
        }
        return saslServer;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.factoryCache.keySet().toArray(new String[0]);
    }
}

