/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.binary;

import org.apache.ignite.binary.BinaryBasicNameMapper;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.configuration.BinaryConfiguration;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.binary.ClientBinaryConfigurationGetResponse;
import org.jetbrains.annotations.Nullable;

public class ClientBinaryConfigurationGetRequest
extends ClientRequest {
    private static final byte NAME_MAPPER_BASIC_FULL = 0;
    private static final byte NAME_MAPPER_BASIC_SIMPLE = 1;
    private static final byte NAME_MAPPER_CUSTOM = 2;

    public ClientBinaryConfigurationGetRequest(BinaryRawReader reader) {
        super(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        BinaryConfiguration cfg = ctx.kernalContext().config().getBinaryConfiguration();
        boolean compactFooter = cfg == null ? true : cfg.isCompactFooter();
        byte nameMapperType = ClientBinaryConfigurationGetRequest.getNameMapperType(cfg);
        return new ClientBinaryConfigurationGetResponse(this.requestId(), compactFooter, nameMapperType);
    }

    private static byte getNameMapperType(@Nullable BinaryConfiguration cfg) {
        if (cfg == null || cfg.getNameMapper() == null) {
            return 0;
        }
        if (!cfg.getNameMapper().getClass().equals(BinaryBasicNameMapper.class)) {
            return 2;
        }
        BinaryBasicNameMapper basicNameMapper = (BinaryBasicNameMapper)cfg.getNameMapper();
        return basicNameMapper.isSimpleName() ? (byte)1 : 0;
    }
}

