/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import javax.cache.Cache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public final class TextQuery<K, V>
extends Query<Cache.Entry<K, V>> {
    private static final long serialVersionUID = 0L;
    private String type;
    private String txt;
    private int limit;

    public TextQuery(String type, String txt) {
        this.setType(type);
        this.setText(txt);
    }

    public TextQuery(String type, String txt, int limit) {
        this.setType(type);
        this.setText(txt);
        this.setLimit(limit);
    }

    public TextQuery(Class<?> type, String txt) {
        this.setType(type);
        this.setText(txt);
    }

    public TextQuery(Class<?> type, String txt, int limit) {
        this.setType(type);
        this.setText(txt);
        this.setLimit(limit);
    }

    public String getType() {
        return this.type;
    }

    public TextQuery<K, V> setType(Class<?> type) {
        return this.setType(QueryUtils.typeName(type));
    }

    public TextQuery<K, V> setType(String type) {
        this.type = type;
        return this;
    }

    public String getText() {
        return this.txt;
    }

    public TextQuery<K, V> setText(String txt) {
        A.notNull(txt, "txt");
        this.txt = txt;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public TextQuery<K, V> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public TextQuery<K, V> setPageSize(int pageSize) {
        return (TextQuery)super.setPageSize(pageSize);
    }

    public TextQuery<K, V> setLocal(boolean loc) {
        return (TextQuery)super.setLocal(loc);
    }

    @Override
    public String toString() {
        return S.toString(TextQuery.class, this);
    }
}

