/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalAsofJoin;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalRepeatUnion;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;

public class RelShuttleImpl
implements RelShuttle {
    protected final Deque<RelNode> stack = new ArrayDeque<RelNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RelNode visitChild(RelNode parent, int i, RelNode child) {
        this.stack.push(parent);
        try {
            RelNode child2 = child.accept(this);
            if (child2 != child) {
                ArrayList<RelNode> newInputs = new ArrayList<RelNode>(parent.getInputs());
                newInputs.set(i, child2);
                RelNode relNode = parent.copy(parent.getTraitSet(), newInputs);
                return relNode;
            }
            RelNode relNode = parent;
            return relNode;
        }
        finally {
            this.stack.pop();
        }
    }

    protected RelNode visitChildren(RelNode rel) {
        for (Ord input : Ord.zip(rel.getInputs())) {
            rel = this.visitChild(rel, input.i, (RelNode)input.e);
        }
        return rel;
    }

    @Override
    public RelNode visit(LogicalAggregate aggregate) {
        return this.visitChild(aggregate, 0, aggregate.getInput());
    }

    @Override
    public RelNode visit(LogicalMatch match) {
        return this.visitChild(match, 0, match.getInput());
    }

    @Override
    public RelNode visit(TableScan scan) {
        return scan;
    }

    @Override
    public RelNode visit(TableFunctionScan scan) {
        return this.visitChildren(scan);
    }

    @Override
    public RelNode visit(LogicalValues values) {
        return values;
    }

    @Override
    public RelNode visit(LogicalFilter filter) {
        return this.visitChild(filter, 0, filter.getInput());
    }

    @Override
    public RelNode visit(LogicalCalc calc) {
        return this.visitChildren(calc);
    }

    @Override
    public RelNode visit(LogicalProject project) {
        return this.visitChild(project, 0, project.getInput());
    }

    @Override
    public RelNode visit(LogicalJoin join) {
        return this.visitChildren(join);
    }

    @Override
    public RelNode visit(LogicalCorrelate correlate) {
        return this.visitChildren(correlate);
    }

    @Override
    public RelNode visit(LogicalUnion union) {
        return this.visitChildren(union);
    }

    @Override
    public RelNode visit(LogicalIntersect intersect) {
        return this.visitChildren(intersect);
    }

    @Override
    public RelNode visit(LogicalMinus minus) {
        return this.visitChildren(minus);
    }

    @Override
    public RelNode visit(LogicalSort sort) {
        return this.visitChildren(sort);
    }

    @Override
    public RelNode visit(LogicalExchange exchange) {
        return this.visitChildren(exchange);
    }

    @Override
    public RelNode visit(LogicalTableModify modify) {
        return this.visitChildren(modify);
    }

    @Override
    public RelNode visit(LogicalAsofJoin logicalAsofJoin) {
        return this.visitChildren(logicalAsofJoin);
    }

    @Override
    public RelNode visit(LogicalRepeatUnion logicalRepeatUnion) {
        return this.visitChildren(logicalRepeatUnion);
    }

    @Override
    public RelNode visit(RelNode other) {
        return this.visitChildren(other);
    }
}

