/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.metrics;

import io.opentelemetry.api.common.Attributes;
import javax.annotation.Nullable;

public interface ExporterMetrics {
    public Recording startRecordingExport(int var1);

    public static abstract class Recording {
        private boolean alreadyEnded = false;

        protected Recording() {
        }

        public final void finishSuccessful(Attributes requestAttributes) {
            this.ensureEndedOnce();
            this.doFinish(null, requestAttributes);
        }

        public final void finishFailed(String errorType, Attributes requestAttributes) {
            this.ensureEndedOnce();
            if (errorType == null || errorType.isEmpty()) {
                throw new IllegalArgumentException("The export failed but no failure reason was provided");
            }
            this.doFinish(errorType, requestAttributes);
        }

        private void ensureEndedOnce() {
            if (this.alreadyEnded) {
                throw new IllegalStateException("Recording already ended");
            }
            this.alreadyEnded = true;
        }

        protected abstract void doFinish(@Nullable String var1, Attributes var2);
    }
}

