/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.common;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hugegraph.pd.grpc.Metapb;

public class GraphCache {
    private Metapb.Graph graph;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean writing = new AtomicBoolean(false);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<Integer, AtomicBoolean> state = new ConcurrentHashMap<Integer, AtomicBoolean>();
    private Map<Integer, Metapb.Partition> partitions = new ConcurrentHashMap<Integer, Metapb.Partition>();
    private RangeMap<Long, Integer> range;

    public GraphCache(Metapb.Graph graph) {
        this.range = (GraphCache)this.new SynchronizedRangeMap<K, V>().rangeMap;
        this.graph = graph;
    }

    public GraphCache() {
        this.range = (GraphCache)this.new SynchronizedRangeMap<K, V>().rangeMap;
    }

    public Metapb.Partition getPartition(Integer id) {
        return this.partitions.get(id);
    }

    public Metapb.Partition addPartition(Integer id, Metapb.Partition p) {
        return this.partitions.put(id, p);
    }

    public Metapb.Partition removePartition(Integer id) {
        return this.partitions.remove(id);
    }

    public Metapb.Graph getGraph() {
        return this.graph;
    }

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }

    public AtomicBoolean getWriting() {
        return this.writing;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public Map<Integer, AtomicBoolean> getState() {
        return this.state;
    }

    public Map<Integer, Metapb.Partition> getPartitions() {
        return this.partitions;
    }

    public RangeMap<Long, Integer> getRange() {
        return this.range;
    }

    public void setGraph(Metapb.Graph graph) {
        this.graph = graph;
    }

    public void setInitialized(AtomicBoolean initialized) {
        this.initialized = initialized;
    }

    public void setWriting(AtomicBoolean writing) {
        this.writing = writing;
    }

    public void setLock(ReentrantReadWriteLock lock) {
        this.lock = lock;
    }

    public void setState(Map<Integer, AtomicBoolean> state) {
        this.state = state;
    }

    public void setPartitions(Map<Integer, Metapb.Partition> partitions) {
        this.partitions = partitions;
    }

    public void setRange(RangeMap<Long, Integer> range) {
        this.range = range;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphCache)) {
            return false;
        }
        GraphCache other = (GraphCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Metapb.Graph this$graph = this.getGraph();
        Metapb.Graph other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !this$graph.equals(other$graph)) {
            return false;
        }
        AtomicBoolean this$initialized = this.getInitialized();
        AtomicBoolean other$initialized = other.getInitialized();
        if (this$initialized == null ? other$initialized != null : !this$initialized.equals(other$initialized)) {
            return false;
        }
        AtomicBoolean this$writing = this.getWriting();
        AtomicBoolean other$writing = other.getWriting();
        if (this$writing == null ? other$writing != null : !this$writing.equals(other$writing)) {
            return false;
        }
        ReentrantReadWriteLock this$lock = this.getLock();
        ReentrantReadWriteLock other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !this$lock.equals(other$lock)) {
            return false;
        }
        Map<Integer, AtomicBoolean> this$state = this.getState();
        Map<Integer, AtomicBoolean> other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Map<Integer, Metapb.Partition> this$partitions = this.getPartitions();
        Map<Integer, Metapb.Partition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        RangeMap<Long, Integer> this$range = this.getRange();
        RangeMap<Long, Integer> other$range = other.getRange();
        return !(this$range == null ? other$range != null : !this$range.equals(other$range));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Metapb.Graph $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        AtomicBoolean $initialized = this.getInitialized();
        result = result * 59 + ($initialized == null ? 43 : $initialized.hashCode());
        AtomicBoolean $writing = this.getWriting();
        result = result * 59 + ($writing == null ? 43 : $writing.hashCode());
        ReentrantReadWriteLock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        Map<Integer, AtomicBoolean> $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Map<Integer, Metapb.Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        RangeMap<Long, Integer> $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        return result;
    }

    public String toString() {
        return "GraphCache(graph=" + this.getGraph() + ", initialized=" + this.getInitialized() + ", writing=" + this.getWriting() + ", lock=" + this.getLock() + ", state=" + this.getState() + ", partitions=" + this.getPartitions() + ", range=" + this.getRange() + ")";
    }

    public class SynchronizedRangeMap<K extends Comparable<K>, V> {
        private final RangeMap<K, V> rangeMap = TreeRangeMap.create();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        public void put(Range<K> range, V value) {
            this.lock.writeLock().lock();
            try {
                this.rangeMap.put(range, value);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public V get(K key) {
            this.lock.readLock().lock();
            try {
                Object object = this.rangeMap.get(key);
                return (V)object;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void remove(Range<K> range) {
            this.lock.writeLock().lock();
            try {
                this.rangeMap.remove(range);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public Map.Entry<Range<K>, V> getEntry(K key) {
            this.lock.readLock().lock();
            try {
                Map.Entry entry = this.rangeMap.getEntry(key);
                return entry;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void clear() {
            this.lock.writeLock().lock();
            try {
                this.rangeMap.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

