/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdbsst;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBStdSessions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.util.E;
import org.rocksdb.EnvOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstFileWriter;

public class RocksDBSstSessions
extends RocksDBSessions {
    private final String dataPath;
    private final Map<String, SstFileWriter> tables;

    public RocksDBSstSessions(HugeConfig config, String database, String store, String dataPath) {
        super(config, database, store);
        this.dataPath = dataPath;
        this.tables = new ConcurrentHashMap<String, SstFileWriter>();
        File path = new File(this.dataPath);
        if (!path.exists()) {
            E.checkState((boolean)path.mkdirs(), (String)"Can't mkdir '%s'", (Object[])new Object[]{path});
        }
    }

    public RocksDBSstSessions(HugeConfig config, String dataPath, String database, String store, List<String> tableNames) throws RocksDBException {
        this(config, dataPath, database, store);
        for (String table : tableNames) {
            this.createTable(table);
        }
    }

    private RocksDBSstSessions(HugeConfig config, String database, String store, RocksDBSstSessions origin) {
        super(config, database, store);
        this.dataPath = origin.dataPath;
        this.tables = origin.tables;
    }

    public void open() throws Exception {
    }

    protected boolean opened() {
        return true;
    }

    @Override
    public Set<String> openedTables() {
        return this.tables.keySet();
    }

    @Override
    public synchronized void createTable(String ... tables) throws RocksDBException {
        for (String table : tables) {
            this.createTable(table);
        }
    }

    private void createTable(String table) throws RocksDBException {
        String number = String.format("%04d", 1);
        Path sstFile = Paths.get(this.dataPath, table, number + ".sst");
        try {
            FileUtils.forceMkdir((File)sstFile.toAbsolutePath().getParent().toFile());
        }
        catch (IOException e) {
            throw new BackendException("Can't make directory for sst: '%s'", (Throwable)e, new Object[]{sstFile.toString()});
        }
        EnvOptions env = new EnvOptions();
        Options options = new Options();
        RocksDBStdSessions.initOptions(this.config(), options, options, options, options);
        options.setMergeOperatorName("not-exist-merge-op");
        SstFileWriter sst = new SstFileWriter(env, options);
        sst.open(sstFile.toString());
        this.tables.put(table, sst);
    }

    @Override
    public synchronized void dropTable(String ... tables) throws RocksDBException {
        for (String table : tables) {
            this.dropTable(table);
        }
    }

    public void dropTable(String table) throws RocksDBException {
        try (SstFileWriter sst = this.tables.remove(table);){
            assert (sst == null || !sst.isOwningHandle()) : "Please close table before drop to ensure call sst.finish()";
        }
    }

    @Override
    public boolean existsTable(String table) {
        return this.tables.containsKey(table);
    }

    @Override
    public List<String> property(String property) {
        throw new UnsupportedOperationException("RocksDBSstStore property()");
    }

    @Override
    public void compactRange() {
        throw new NotSupportException("RocksDBSstStore compactRange()");
    }

    @Override
    public RocksDBSessions copy(HugeConfig config, String database, String store) {
        return new RocksDBSstSessions(config, database, store, this);
    }

    @Override
    public void createSnapshot(String snapshotPath) {
        throw new UnsupportedOperationException("createSnapshot");
    }

    @Override
    public void resumeSnapshot(String snapshotPath) {
        throw new UnsupportedOperationException("resumeSnapshot");
    }

    @Override
    public String buildSnapshotPath(String snapshotPrefix) {
        throw new UnsupportedOperationException("buildSnapshotPath");
    }

    @Override
    public String hardLinkSnapshot(String snapshotPath) {
        throw new UnsupportedOperationException("hardLinkSnapshot");
    }

    @Override
    public void reloadRocksDB() {
        throw new UnsupportedOperationException("reloadRocksDB");
    }

    @Override
    public void forceCloseRocksDB() {
        throw new UnsupportedOperationException("forceCloseRocksDB");
    }

    private SstFileWriter table(String table) {
        SstFileWriter sst = this.tables.get(table);
        if (sst == null) {
            throw new BackendException("Table '%s' is not opened", new Object[]{table});
        }
        return sst;
    }

    @Override
    public final RocksDBSessions.Session session() {
        return (RocksDBSessions.Session)super.getOrNewSession();
    }

    protected RocksDBSessions.Session newSession() {
        return new SstSession();
    }

    protected synchronized void doClose() {
        String NO_ENTRIES = "Can't create sst file with no entries";
        for (SstFileWriter sst : this.tables.values()) {
            E.checkState((boolean)sst.isOwningHandle(), (String)"SstFileWriter closed", (Object[])new Object[0]);
            try {
                sst.finish();
            }
            catch (RocksDBException e) {
                if (e.getMessage().equals("Can't create sst file with no entries")) continue;
                throw new BackendException("Failed to close SstFileWriter", (Throwable)e);
            }
            sst.close();
        }
        this.tables.clear();
    }

    private static class Changes
    extends ArrayList<Pair<byte[], byte[]>> {
        private static final long serialVersionUID = 9047034706183029125L;

        private Changes() {
        }
    }

    private final class SstSession
    extends RocksDBSessions.Session {
        private final Map<String, Changes> batch = new HashMap<String, Changes>();

        public void open() {
            this.opened = true;
        }

        public void close() {
            assert (this.closeable());
            this.opened = false;
        }

        public boolean hasChanges() {
            return !this.batch.isEmpty();
        }

        public Integer commit() {
            int count = this.batch.size();
            if (count == 0) {
                return 0;
            }
            try {
                for (Map.Entry<String, Changes> table : this.batch.entrySet()) {
                    if (table.getValue().isEmpty() || table.getKey().endsWith("i")) continue;
                    SstFileWriter sst = RocksDBSstSessions.this.table(table.getKey());
                    for (Pair change : table.getValue()) {
                        sst.put((byte[])change.getKey(), (byte[])change.getValue());
                    }
                }
            }
            catch (RocksDBException e) {
                throw new BackendException("Failed to commit", (Throwable)e);
            }
            this.batch.clear();
            return count;
        }

        public void rollback() {
            this.batch.clear();
        }

        @Override
        public String dataPath() {
            return RocksDBSstSessions.this.dataPath;
        }

        @Override
        public String walPath() {
            return RocksDBSstSessions.this.dataPath;
        }

        @Override
        public String property(String table, String property) {
            throw new NotSupportException("RocksDBSstStore property()");
        }

        @Override
        public Pair<byte[], byte[]> keyRange(String table) {
            return null;
        }

        @Override
        public void compactRange(String table) {
            throw new NotSupportException("RocksDBSstStore compactRange()");
        }

        @Override
        public void put(String table, byte[] key, byte[] value) {
            Changes changes = this.batch.get(table);
            if (changes == null) {
                changes = new Changes();
                this.batch.put(table, changes);
            }
            changes.add(Pair.of((Object)key, (Object)value));
        }

        @Override
        public void merge(String table, byte[] key, byte[] value) {
            throw new NotSupportException("RocksDBSstStore merge()");
        }

        @Override
        public void increase(String table, byte[] key, byte[] value) {
            throw new NotSupportException("RocksDBSstStore increase()");
        }

        @Override
        public void delete(String table, byte[] key) {
            throw new NotSupportException("RocksDBSstStore delete()");
        }

        @Override
        public void deleteSingle(String table, byte[] key) {
            throw new NotSupportException("RocksDBSstStore deleteSingle()");
        }

        @Override
        public void deletePrefix(String table, byte[] key) {
            throw new NotSupportException("RocksDBSstStore deletePrefix()");
        }

        @Override
        public void deleteRange(String table, byte[] keyFrom, byte[] keyTo) {
            throw new NotSupportException("RocksDBSstStore deleteRange()");
        }

        @Override
        public byte[] get(String table, byte[] key) {
            return null;
        }

        @Override
        public BackendEntry.BackendColumnIterator get(String table, List<byte[]> keys) {
            assert (!this.hasChanges());
            return BackendEntry.BackendColumnIterator.empty();
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table) {
            assert (!this.hasChanges());
            return BackendEntry.BackendColumnIterator.empty();
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] prefix) {
            assert (!this.hasChanges());
            return BackendEntry.BackendColumnIterator.empty();
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] keyFrom, byte[] keyTo, int scanType) {
            assert (!this.hasChanges());
            return BackendEntry.BackendColumnIterator.empty();
        }
    }
}

