/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.iterator.ListIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.HugeTaskResult;
import org.apache.hugegraph.task.ServerInfoManager;
import org.apache.hugegraph.task.TaskAndResultTransaction;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.task.TaskStatus;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class TaskAndResultScheduler
implements TaskScheduler {
    protected final HugeGraphParams graph;
    protected final String graphSpace;
    protected final String graphName;
    protected volatile TaskAndResultTransaction taskTx = null;
    private final ServerInfoManager serverManager;

    public TaskAndResultScheduler(HugeGraphParams graph, ExecutorService serverInfoDbExecutor) {
        E.checkNotNull((Object)graph, (String)"graph");
        this.graph = graph;
        this.graphSpace = "";
        this.graphName = graph.name();
        this.serverManager = new ServerInfoManager(graph, serverInfoDbExecutor);
    }

    @Override
    public <V> void save(HugeTask<V> task) {
        E.checkArgumentNotNull(task, (String)"Task can't be null", (Object[])new Object[0]);
        String rawResult = task.result();
        this.call(() -> {
            HugeVertex vertex = this.tx().constructTaskVertex(task);
            this.tx().deleteIndex(vertex);
            return this.tx().addVertex(vertex);
        });
        if (rawResult != null) {
            HugeTaskResult result = new HugeTaskResult(HugeTaskResult.genId(task.id()));
            result.result(rawResult);
            this.call(() -> {
                HugeVertex vertex = this.tx().constructTaskResultVertex(result);
                return this.tx().addVertex(vertex);
            });
        }
    }

    @Override
    public <V> HugeTask<V> task(Id id) {
        HugeTask task = this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(id);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            return HugeTask.fromVertex(vertex);
        });
        if (task == null) {
            throw new NotFoundException("Can't find task with id '%s'", id);
        }
        HugeTaskResult taskResult = this.queryTaskResult(id);
        if (taskResult != null) {
            task.result(taskResult);
        }
        return task;
    }

    @Override
    public <V> Iterator<HugeTask<V>> tasks(List<Id> ids) {
        return this.tasksWithoutResult(ids);
    }

    @Override
    public <V> Iterator<HugeTask<V>> tasks(TaskStatus status, long limit, String page) {
        if (status == null) {
            return this.queryTaskWithoutResult((Map<String, Object>)ImmutableMap.of(), limit, page);
        }
        return this.queryTaskWithoutResult("~task_status", status.code(), limit, page);
    }

    protected <V> Iterator<HugeTask<V>> queryTask(String key, Object value, long limit, String page) {
        return this.queryTask((Map<String, Object>)ImmutableMap.of((Object)key, (Object)value), limit, page);
    }

    protected <V> Iterator<HugeTask<V>> queryTask(Map<String, Object> conditions, long limit, String page) {
        Iterator ts = (Iterator)this.call(() -> {
            ConditionQuery query = new ConditionQuery(HugeType.TASK);
            if (page != null) {
                query.page(page);
            }
            VertexLabel vl = this.graph().vertexLabel(HugeTask.P.TASK);
            query.eq(HugeKeys.LABEL, vl.id());
            for (Map.Entry entry : conditions.entrySet()) {
                PropertyKey pk = this.graph().propertyKey((String)entry.getKey());
                query.query(Condition.eq(pk.id(), entry.getValue()));
            }
            query.showHidden(true);
            if (limit != -1L) {
                query.limit(limit);
            }
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(query);
            MapperIterator tasks = new MapperIterator(vertices, HugeTask::fromVertex);
            return QueryResults.toList(tasks);
        });
        return new MapperIterator(ts, task -> {
            HugeTaskResult taskResult = this.queryTaskResult(task.id());
            if (taskResult != null) {
                task.result(taskResult);
            }
            return task;
        });
    }

    protected <V> Iterator<HugeTask<V>> queryTask(List<Id> ids) {
        ListIterator ts = this.call(() -> {
            Object[] idArray = ids.toArray(new Id[ids.size()]);
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(idArray);
            MapperIterator tasks = new MapperIterator(vertices, HugeTask::fromVertex);
            return QueryResults.toList(tasks);
        });
        Iterator<HugeTaskResult> results = this.queryTaskResult(ids);
        HashMap<String, HugeTaskResult> resultCaches = new HashMap<String, HugeTaskResult>();
        while (results.hasNext()) {
            HugeTaskResult entry = results.next();
            resultCaches.put(entry.taskResultId(), entry);
        }
        return new MapperIterator((Iterator)ts, task -> {
            HugeTaskResult taskResult = (HugeTaskResult)resultCaches.get(HugeTaskResult.genId(task.id()));
            if (taskResult != null) {
                task.result(taskResult);
            }
            return task;
        });
    }

    protected <V> HugeTask<V> taskWithoutResult(Id id) {
        HugeTask result = this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(id);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            return HugeTask.fromVertex(vertex);
        });
        return result;
    }

    protected <V> Iterator<HugeTask<V>> tasksWithoutResult(List<Id> ids) {
        return (Iterator)this.call(() -> {
            Object[] idArray = ids.toArray(new Id[ids.size()]);
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(idArray);
            MapperIterator tasks = new MapperIterator(vertices, HugeTask::fromVertex);
            return QueryResults.toList(tasks);
        });
    }

    protected <V> Iterator<HugeTask<V>> tasksWithoutResult(TaskStatus status, long limit, String page) {
        if (status == null) {
            return this.queryTaskWithoutResult((Map<String, Object>)ImmutableMap.of(), limit, page);
        }
        return this.queryTaskWithoutResult("~task_status", status.code(), limit, page);
    }

    protected <V> Iterator<HugeTask<V>> queryTaskWithoutResult(String key, Object value, long limit, String page) {
        return this.queryTaskWithoutResult((Map<String, Object>)ImmutableMap.of((Object)key, (Object)value), limit, page);
    }

    protected <V> Iterator<HugeTask<V>> queryTaskWithoutResult(Map<String, Object> conditions, long limit, String page) {
        return (Iterator)this.call(() -> {
            ConditionQuery query = new ConditionQuery(HugeType.TASK);
            if (page != null) {
                query.page(page);
            }
            VertexLabel vl = this.graph().vertexLabel(HugeTask.P.TASK);
            query.eq(HugeKeys.LABEL, vl.id());
            for (Map.Entry entry : conditions.entrySet()) {
                PropertyKey pk = this.graph().propertyKey((String)entry.getKey());
                query.query(Condition.eq(pk.id(), entry.getValue()));
            }
            query.showHidden(true);
            if (limit != -1L) {
                query.limit(limit);
            }
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(query);
            MapperIterator tasks = new MapperIterator(vertices, HugeTask::fromVertex);
            return QueryResults.toList(tasks);
        });
    }

    protected HugeTaskResult queryTaskResult(Id taskid) {
        HugeTaskResult result = this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(HugeTaskResult.genId(taskid));
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            return HugeTaskResult.fromVertex(vertex);
        });
        return result;
    }

    protected Iterator<HugeTaskResult> queryTaskResult(List<Id> taskIds) {
        return (Iterator)this.call(() -> {
            Object[] idArray = taskIds.stream().map(HugeTaskResult::genId).toArray();
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(idArray);
            MapperIterator tasks = new MapperIterator(vertices, HugeTaskResult::fromVertex);
            return QueryResults.toList(tasks);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskAndResultTransaction tx() {
        if (this.taskTx == null) {
            ServerInfoManager serverInfoManager = this.serverManager;
            synchronized (serverInfoManager) {
                if (this.taskTx == null) {
                    BackendStore store = this.graph.loadSystemStore();
                    TaskAndResultTransaction tx = new TaskAndResultTransaction(this.graph, store);
                    assert (this.taskTx == null);
                    this.taskTx = tx;
                }
            }
        }
        assert (this.taskTx != null);
        return this.taskTx;
    }

    @Override
    public ServerInfoManager serverManager() {
        return this.serverManager;
    }
}

