/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.space;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.util.E;

public class Service {
    public static final int DEFAULT_COUNT = 1;
    public static final String DEFAULT_ROUTE_TYPE = "NodePort";
    public static final int DEFAULT_PORT = 0;
    public static final int DEFAULT_CPU_LIMIT = 4;
    public static final int DEFAULT_MEMORY_LIMIT = 8;
    public static final int DEFAULT_STORAGE_LIMIT = 100;
    private final String creator;
    private String name;
    private ServiceType type;
    private DeploymentType deploymentType;
    private String description;
    private Status status;
    private int count;
    private int running;
    private int cpuLimit;
    private int memoryLimit;
    private int storageLimit;
    private String routeType;
    private int port;
    private Set<String> urls = new HashSet<String>();
    private Set<String> serverDdsUrls = new HashSet<String>();
    private Set<String> serverNodePortUrls = new HashSet<String>();
    private String serviceId;
    private String pdServiceId;
    private Date createTime;
    private Date updateTime;

    public Service(String name, String creator, ServiceType type, DeploymentType deploymentType) {
        E.checkArgument((name != null && !StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"The name of service can't be null or empty", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)((Object)type), (String)"The type of service can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)((Object)deploymentType), (String)"The deployment type of service can't be null", (Object[])new Object[0]);
        this.name = name;
        this.type = type;
        this.deploymentType = deploymentType;
        this.status = Status.UNKNOWN;
        this.count = 1;
        this.running = 0;
        this.routeType = DEFAULT_ROUTE_TYPE;
        this.port = 0;
        this.cpuLimit = 4;
        this.memoryLimit = 8;
        this.storageLimit = 100;
        this.creator = creator;
        this.updateTime = this.createTime = new Date();
    }

    public Service(String name, String creator, String description, ServiceType type, DeploymentType deploymentType, int count, int running, int cpuLimit, int memoryLimit, int storageLimit, String routeType, int port, Set<String> urls) {
        E.checkArgument((name != null && !StringUtils.isEmpty((String)name) ? 1 : 0) != 0, (String)"The name of service can't be null or empty", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)((Object)type), (String)"The type of service can't be null", (Object[])new Object[0]);
        this.name = name;
        this.description = description;
        this.type = type;
        this.status = Status.UNKNOWN;
        this.deploymentType = deploymentType;
        this.count = count;
        this.running = running;
        this.cpuLimit = cpuLimit;
        this.memoryLimit = memoryLimit;
        this.storageLimit = storageLimit;
        this.routeType = routeType;
        this.port = port;
        this.urls = urls;
        this.creator = creator;
        this.updateTime = this.createTime = new Date();
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public ServiceType type() {
        return this.type;
    }

    public void type(ServiceType type) {
        this.type = type;
    }

    public DeploymentType deploymentType() {
        return this.deploymentType;
    }

    public void deploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public Status status() {
        return this.status;
    }

    public void status(Status status) {
        this.status = status;
    }

    public int count() {
        return this.count;
    }

    public void count(int count) {
        E.checkArgument((count > 0 ? 1 : 0) != 0, (String)"The service count must be > 0, but got: %s", (Object[])new Object[]{count});
        this.count = count;
    }

    public int running() {
        return this.running;
    }

    public void running(int running) {
        E.checkArgument((running <= this.count ? 1 : 0) != 0, (String)"The running count must be < count %s, but got: %s", (Object[])new Object[]{this.count, running});
        this.running = running;
    }

    public int cpuLimit() {
        return this.cpuLimit;
    }

    public void cpuLimit(int cpuLimit) {
        E.checkArgument((cpuLimit > 0 ? 1 : 0) != 0, (String)"The cpu limit must be > 0, but got: %s", (Object[])new Object[]{cpuLimit});
        this.cpuLimit = cpuLimit;
    }

    public int memoryLimit() {
        return this.memoryLimit;
    }

    public void memoryLimit(int memoryLimit) {
        E.checkArgument((memoryLimit > 0 ? 1 : 0) != 0, (String)"The memory limit must be > 0, but got: %s", (Object[])new Object[]{memoryLimit});
        this.memoryLimit = memoryLimit;
    }

    public int storageLimit() {
        return this.storageLimit;
    }

    public void storageLimit(int storageLimit) {
        E.checkArgument((storageLimit > 0 ? 1 : 0) != 0, (String)"The storage limit must be > 0, but got: %s", (Object[])new Object[]{storageLimit});
        this.storageLimit = storageLimit;
    }

    public String routeType() {
        return this.routeType;
    }

    public void routeType(String routeType) {
        this.routeType = routeType;
    }

    public int port() {
        return this.port;
    }

    public void port(int port) {
        this.port = port;
    }

    public Set<String> urls() {
        if (this.urls == null) {
            this.urls = new HashSet<String>();
        }
        return this.urls;
    }

    public void urls(Set<String> urls) {
        this.urls = urls;
    }

    public Set<String> serverDdsUrls() {
        if (this.serverDdsUrls == null) {
            this.serverDdsUrls = new HashSet<String>();
        }
        return this.serverDdsUrls;
    }

    public void serverDdsUrls(Set<String> urls) {
        this.serverDdsUrls = urls;
    }

    public Set<String> serverNodePortUrls() {
        if (this.serverNodePortUrls == null) {
            this.serverNodePortUrls = new HashSet<String>();
        }
        return this.serverNodePortUrls;
    }

    public void serverNodePortUrls(Set<String> urls) {
        this.serverNodePortUrls = urls;
    }

    public void url(String url) {
        if (this.urls == null) {
            this.urls = new HashSet<String>();
        }
        this.urls.add(url);
    }

    public boolean manual() {
        return DeploymentType.MANUAL.equals((Object)this.deploymentType);
    }

    public boolean k8s() {
        return DeploymentType.K8S.equals((Object)this.deploymentType);
    }

    public String creator() {
        return this.creator;
    }

    public Date createdTime() {
        return this.createTime;
    }

    public Date updateTime() {
        return this.updateTime;
    }

    public void createTime(Date create) {
        this.createTime = create;
    }

    public void updateTime(Date update) {
        this.updateTime = update;
    }

    public void refreshUpdate() {
        this.updateTime = new Date();
    }

    public boolean sameService(Service other) {
        if (other.deploymentType == DeploymentType.K8S || this.deploymentType == DeploymentType.K8S) {
            return true;
        }
        return this.name.equals(other.name) && this.type.equals((Object)other.type) && this.deploymentType == other.deploymentType && this.urls.equals(other.urls) && this.port == other.port;
    }

    public Map<String, Object> info() {
        LinkedHashMap<String, Object> infos = new LinkedHashMap<String, Object>();
        infos.put("name", this.name);
        infos.put("type", (Object)this.type);
        infos.put("deployment_type", (Object)this.deploymentType);
        infos.put("description", this.description);
        infos.put("status", (Object)this.status);
        infos.put("count", this.count);
        infos.put("running", this.running);
        infos.put("cpu_limit", this.cpuLimit);
        infos.put("memory_limit", this.memoryLimit);
        infos.put("storage_limit", this.storageLimit);
        infos.put("route_type", this.routeType);
        infos.put("port", this.port);
        infos.put("urls", this.urls);
        infos.put("server_dds_urls", this.serverDdsUrls);
        infos.put("server_node_port_urls", this.serverNodePortUrls);
        infos.put("service_id", this.serviceId);
        infos.put("pd_service_id", this.pdServiceId);
        infos.put("creator", this.creator);
        infos.put("create_time", this.createTime);
        infos.put("update_time", this.updateTime);
        return infos;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public void serviceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String pdServiceId() {
        return this.pdServiceId;
    }

    public void pdServiceId(String serviceId) {
        this.pdServiceId = serviceId;
    }

    public static enum Status {
        UNKNOWN,
        STARTING,
        RUNNING,
        STOPPED;

    }

    public static enum ServiceType {
        OLTP,
        OLAP,
        STORAGE;

    }

    public static enum DeploymentType {
        MANUAL,
        K8S;

    }
}

