/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.type.define.SchemaStatus;

public class VertexLabel
extends SchemaLabel {
    public static final VertexLabel NONE = new VertexLabel(null, NONE_ID, "~undefined");
    private static final Id OLAP_VL_ID = IdGenerator.of(-7L);
    private static final String OLAP_VL_NAME = "*olap";
    public static final VertexLabel OLAP_VL = new VertexLabel(null, OLAP_VL_ID, "*olap");
    private IdStrategy idStrategy = IdStrategy.DEFAULT;
    private List<Id> primaryKeys = new ArrayList<Id>();

    public VertexLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.VERTEX_LABEL;
    }

    public boolean olap() {
        return OLAP_VL.id().equals(this.id());
    }

    public IdStrategy idStrategy() {
        return this.idStrategy;
    }

    public void idStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public List<Id> primaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public void primaryKey(Id id) {
        this.primaryKeys.add(id);
    }

    public void primaryKeys(Id ... ids) {
        this.primaryKeys.addAll(Arrays.asList(ids));
    }

    public boolean existsLinkLabel() {
        return this.graph().existsLinkLabel(this.id());
    }

    public boolean hasSameContent(VertexLabel other) {
        return super.hasSameContent(other) && this.idStrategy == other.idStrategy && Objects.equal(this.graph.mapPkId2Name(this.primaryKeys), other.graph.mapPkId2Name(other.primaryKeys));
    }

    public static VertexLabel undefined(HugeGraph graph) {
        return new VertexLabel(graph, NONE_ID, "~undefined");
    }

    public static VertexLabel undefined(HugeGraph graph, Id id) {
        return new VertexLabel(graph, id, "~undefined");
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("properties", this.properties());
        map.put("nullableKeys", this.nullableKeys());
        map.put("indexLabels", this.indexLabels());
        map.put("enableLabelIndex", this.enableLabelIndex());
        map.put("ttl", String.valueOf(this.ttl()));
        map.put("ttlStartTime", this.ttlStartTime().asString());
        map.put("idStrategy", this.idStrategy().string());
        map.put("primaryKeys", this.primaryKeys());
        return super.asMap(map);
    }

    public static VertexLabel fromMap(Map<String, Object> map, HugeGraph graph) {
        Id id = IdGenerator.of(((Integer)map.get("id")).intValue());
        String name = (String)map.get("name");
        VertexLabel vertexLabel = new VertexLabel(graph, id, name);
        block27: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "name": {
                    continue block27;
                }
                case "status": {
                    vertexLabel.status(SchemaStatus.valueOf(((String)entry.getValue()).toUpperCase()));
                    continue block27;
                }
                case "userdata": {
                    vertexLabel.userdata(new Userdata((Map)entry.getValue()));
                    continue block27;
                }
                case "properties": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.properties(ids);
                    continue block27;
                }
                case "nullableKeys": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.nullableKeys(ids);
                    continue block27;
                }
                case "indexLabels": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.addIndexLabels(ids.toArray(new Id[0]));
                    continue block27;
                }
                case "enableLabelIndex": {
                    boolean enableLabelIndex = (Boolean)entry.getValue();
                    vertexLabel.enableLabelIndex(enableLabelIndex);
                    continue block27;
                }
                case "ttl": {
                    long ttl = Long.parseLong((String)entry.getValue());
                    vertexLabel.ttl(ttl);
                    continue block27;
                }
                case "ttlStartTime": {
                    long ttlStartTime = Long.parseLong((String)entry.getValue());
                    vertexLabel.ttlStartTime(IdGenerator.of(ttlStartTime));
                    continue block27;
                }
                case "idStrategy": {
                    IdStrategy idStrategy = IdStrategy.valueOf(((String)entry.getValue()).toUpperCase());
                    vertexLabel.idStrategy(idStrategy);
                    continue block27;
                }
                case "primaryKeys": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.primaryKeys(ids.toArray(new Id[0]));
                    continue block27;
                }
            }
            throw new AssertionError((Object)String.format("Invalid key '%s' for vertex label", entry.getKey()));
        }
        return vertexLabel;
    }

    public static final class P {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String STATUS = "status";
        public static final String USERDATA = "userdata";
        public static final String PROPERTIES = "properties";
        public static final String NULLABLE_KEYS = "nullableKeys";
        public static final String INDEX_LABELS = "indexLabels";
        public static final String ENABLE_LABEL_INDEX = "enableLabelIndex";
        public static final String TTL = "ttl";
        public static final String TT_START_TIME = "ttlStartTime";
        public static final String ID_STRATEGY = "idStrategy";
        public static final String PRIMARY_KEYS = "primaryKeys";
    }

    public static interface Builder
    extends SchemaBuilder<VertexLabel> {
        public Id rebuildIndex();

        public Builder idStrategy(IdStrategy var1);

        public Builder useAutomaticId();

        public Builder usePrimaryKeyId();

        public Builder useCustomizeStringId();

        public Builder useCustomizeNumberId();

        public Builder useCustomizeUuidId();

        public Builder properties(String ... var1);

        public Builder primaryKeys(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

