/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.watch;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.grpc.watch.WatchChangeType;
import org.apache.hugegraph.pd.grpc.watch.WatchResponse;
import org.apache.hugegraph.pd.grpc.watch.WatchType;
import org.apache.hugegraph.pd.watch.AbstractWatchSubject;

@ThreadSafe
final class PartitionChangeSubject
extends AbstractWatchSubject {
    PartitionChangeSubject() {
        super(WatchType.WATCH_TYPE_PARTITION_CHANGE);
    }

    String toNoticeString(WatchResponse res) {
        String sb = "graph:" + res.getPartitionResponse().getGraph() + ",partitionId:" + res.getPartitionResponse().getPartitionId();
        return sb;
    }

    public void notifyWatcher(WatchChangeType changeType, String graph, int partitionId) {
        HgAssert.isArgumentNotNull((Object)changeType, (String)"changeType");
        HgAssert.isArgumentValid((String)graph, (String)"graph");
        super.notifyWatcher(builder -> builder.setPartitionResponse(builder.getPartitionResponseBuilder().clear().setGraph(graph).setPartitionId(partitionId).setChangeType(changeType).build()));
    }
}

