/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.core;

import com.alipay.remoting.rpc.RpcServer;
import com.alipay.sofa.rpc.config.ServerConfig;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.auth.StandardAuthenticator;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.cache.Cache;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.store.BackendStoreInfo;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.masterelection.GlobalMasterInfo;
import org.apache.hugegraph.masterelection.RoleElectionOptions;
import org.apache.hugegraph.masterelection.RoleElectionStateMachine;
import org.apache.hugegraph.masterelection.RoleListener;
import org.apache.hugegraph.masterelection.StandardRoleListener;
import org.apache.hugegraph.metrics.MetricsUtil;
import org.apache.hugegraph.metrics.ServerReporter;
import org.apache.hugegraph.rpc.RpcClientProvider;
import org.apache.hugegraph.rpc.RpcConsumerConfig;
import org.apache.hugegraph.rpc.RpcProviderConfig;
import org.apache.hugegraph.rpc.RpcServiceConfig4Client;
import org.apache.hugegraph.rpc.RpcServiceConfig4Server;
import org.apache.hugegraph.serializer.JsonSerializer;
import org.apache.hugegraph.serializer.Serializer;
import org.apache.hugegraph.server.RestServer;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.type.define.NodeRole;
import org.apache.hugegraph.util.ConfigUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;

public final class GraphManager {
    private static final Logger LOG = Log.logger(GraphManager.class);
    private final String graphsDir;
    private final Map<String, Graph> graphs;
    private final HugeAuthenticator authenticator;
    private final org.apache.hugegraph.rpc.RpcServer rpcServer;
    private final RpcClientProvider rpcClient;
    private RoleElectionStateMachine roleStateMachine;
    private final GlobalMasterInfo globalNodeRoleInfo;
    private final HugeConfig conf;
    private final EventHub eventHub;

    public GraphManager(HugeConfig conf, EventHub hub) {
        this.graphsDir = (String)conf.get(ServerOptions.GRAPHS);
        this.graphs = new ConcurrentHashMap<String, Graph>();
        this.authenticator = HugeAuthenticator.loadAuthenticator(conf);
        this.rpcServer = new org.apache.hugegraph.rpc.RpcServer(conf);
        this.rpcClient = new RpcClientProvider(conf);
        this.roleStateMachine = null;
        this.globalNodeRoleInfo = new GlobalMasterInfo();
        this.eventHub = hub;
        this.conf = conf;
    }

    public void init() {
        E.checkArgument((boolean)this.graphs.isEmpty(), (String)"GraphManager has been initialized before", (Object[])new Object[0]);
        this.listenChanges();
        this.loadGraphs(ConfigUtil.scanGraphsDir((String)this.graphsDir));
        this.startRpcServer();
        this.waitGraphsReady();
        this.checkBackendVersionOrExit(this.conf);
        this.serverStarted(this.conf);
        this.addMetrics(this.conf);
    }

    public void loadGraphs(Map<String, String> graphConfs) {
        for (Map.Entry<String, String> conf : graphConfs.entrySet()) {
            String name = conf.getKey();
            String graphConfPath = conf.getValue();
            HugeFactory.checkGraphName((String)name, (String)"rest-server.properties");
            try {
                this.loadGraph(name, graphConfPath);
            }
            catch (Throwable e) {
                LOG.error("Graph '{}' can't be loaded: '{}'", new Object[]{name, graphConfPath, e});
            }
        }
    }

    public HugeGraph cloneGraph(String name, String newName, String configText) {
        HugeGraph cloneGraph = this.graph(name);
        E.checkArgumentNotNull((Object)cloneGraph, (String)"The clone graph '%s' doesn't exist", (Object[])new Object[]{name});
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)newName), (String)"The graph name can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((!this.graphs().contains(newName) ? 1 : 0) != 0, (String)"The graph '%s' has existed", (Object[])new Object[]{newName});
        HugeConfig cloneConfig = cloneGraph.cloneConfig(newName);
        if (StringUtils.isNotEmpty((CharSequence)configText)) {
            PropertiesConfiguration propConfig = ConfigUtil.buildConfig((String)configText);
            propConfig.getKeys().forEachRemaining(key -> cloneConfig.setProperty(key, propConfig.getProperty(key)));
            this.checkOptions(cloneConfig);
        }
        return this.createGraph(cloneConfig, newName);
    }

    public HugeGraph createGraph(String name, String configText) {
        E.checkArgument((boolean)((Boolean)this.conf.get(ServerOptions.ENABLE_DYNAMIC_CREATE_DROP)), (String)"Not allowed to create graph '%s' dynamically, please set `enable_dynamic_create_drop` to true.", (Object[])new Object[]{name});
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)name), (String)"The graph name can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((!this.graphs().contains(name) ? 1 : 0) != 0, (String)"The graph name '%s' has existed", (Object[])new Object[]{name});
        PropertiesConfiguration propConfig = ConfigUtil.buildConfig((String)configText);
        HugeConfig config = new HugeConfig((Configuration)propConfig);
        this.checkOptions(config);
        return this.createGraph(config, name);
    }

    public void dropGraph(String name) {
        HugeGraph graph = this.graph(name);
        E.checkArgument((boolean)((Boolean)this.conf.get(ServerOptions.ENABLE_DYNAMIC_CREATE_DROP)), (String)"Not allowed to drop graph '%s' dynamically, please set `enable_dynamic_create_drop` to true.", (Object[])new Object[]{name});
        E.checkArgumentNotNull((Object)graph, (String)"The graph '%s' doesn't exist", (Object[])new Object[]{name});
        E.checkArgument((this.graphs.size() > 1 ? 1 : 0) != 0, (String)"The graph '%s' is the only one, not allowed to delete", (Object[])new Object[]{name});
        this.dropGraph(graph);
        this.notifyAndWaitEvent("graph.drop", graph);
    }

    public Set<String> graphs() {
        return Collections.unmodifiableSet(this.graphs.keySet());
    }

    public HugeGraph graph(String name) {
        Graph graph = this.graphs.get(name);
        if (graph == null) {
            return null;
        }
        if (graph instanceof HugeGraph) {
            return (HugeGraph)graph;
        }
        throw new NotSupportException("graph instance of %s", new Object[]{graph.getClass()});
    }

    public Serializer serializer(Graph g) {
        return JsonSerializer.instance();
    }

    public Serializer serializer(Graph g, Map<String, Object> apiMeasure) {
        return JsonSerializer.instance(apiMeasure);
    }

    public void rollbackAll() {
        for (Graph graph : this.graphs.values()) {
            if (!graph.features().graph().supportsTransactions() || !graph.tx().isOpen()) continue;
            graph.tx().rollback();
        }
    }

    public void rollback(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.ROLLBACK);
    }

    public void commitAll() {
        for (Graph graph : this.graphs.values()) {
            if (!graph.features().graph().supportsTransactions() || !graph.tx().isOpen()) continue;
            graph.tx().commit();
        }
    }

    public void commit(Set<String> graphSourceNamesToCloseTxOn) {
        this.closeTx(graphSourceNamesToCloseTxOn, Transaction.Status.COMMIT);
    }

    public boolean requireAuthentication() {
        if (this.authenticator == null) {
            return false;
        }
        return this.authenticator.requireAuthentication();
    }

    public HugeAuthenticator.User authenticate(Map<String, String> credentials) throws AuthenticationException {
        return this.authenticator().authenticate((Map)credentials);
    }

    public void unauthorized(SecurityContext context) {
        this.authenticator().unauthorize(context);
    }

    public AuthManager authManager() {
        return this.authenticator().authManager();
    }

    public GlobalMasterInfo globalNodeRoleInfo() {
        return this.globalNodeRoleInfo;
    }

    public void close() {
        for (Graph graph : this.graphs.values()) {
            try {
                graph.close();
            }
            catch (Throwable e) {
                LOG.warn("Failed to close graph '{}'", (Object)graph, (Object)e);
            }
        }
        this.destroyRpcServer();
        this.unlistenChanges();
        if (this.roleStateMachine != null) {
            this.roleStateMachine.shutdown();
        }
    }

    private void startRpcServer() {
        if (!this.rpcServer.enabled()) {
            LOG.info("RpcServer is not enabled, skip starting rpc service");
            return;
        }
        RpcProviderConfig serverConfig = this.rpcServer.config();
        if (this.authenticator != null) {
            serverConfig.addService(AuthManager.class, (Object)this.authenticator.authManager());
        }
        if (this.rpcClient.enabled()) {
            RpcConsumerConfig clientConfig = this.rpcClient.config();
            for (Graph graph : this.graphs.values()) {
                HugeGraph hugegraph = (HugeGraph)graph;
                hugegraph.registerRpcServices((RpcServiceConfig4Server)serverConfig, (RpcServiceConfig4Client)clientConfig);
            }
        }
        try {
            this.rpcServer.exportAll();
        }
        catch (Throwable e) {
            this.rpcServer.destroy();
            throw e;
        }
    }

    private RpcServer remotingRpcServer() {
        ServerConfig serverConfig = (ServerConfig)Whitebox.getInternalState((Object)this.rpcServer, (String)"serverConfig");
        serverConfig.buildIfAbsent();
        if (!serverConfig.getServer().isStarted()) {
            serverConfig.getServer().start();
        }
        return (RpcServer)Whitebox.getInternalState((Object)serverConfig.getServer(), (String)"remotingServer");
    }

    private void destroyRpcServer() {
        try {
            this.rpcClient.destroy();
        }
        finally {
            this.rpcServer.destroy();
        }
    }

    private HugeAuthenticator authenticator() {
        E.checkState((this.authenticator != null ? 1 : 0) != 0, (String)"Unconfigured authenticator, please config auth.authenticator option in rest-server.properties", (Object[])new Object[0]);
        return this.authenticator;
    }

    private void closeTx(Set<String> graphSourceNamesToCloseTxOn, Transaction.Status tx) {
        HashSet graphsToCloseTxOn = new HashSet();
        graphSourceNamesToCloseTxOn.forEach(name -> {
            if (this.graphs.containsKey(name)) {
                graphsToCloseTxOn.add(this.graphs.get(name));
            }
        });
        graphsToCloseTxOn.forEach(graph -> {
            if (graph.features().graph().supportsTransactions() && graph.tx().isOpen()) {
                if (tx == Transaction.Status.COMMIT) {
                    graph.tx().commit();
                } else {
                    graph.tx().rollback();
                }
            }
        });
    }

    private void loadGraph(String name, String graphConfPath) {
        HugeConfig config = new HugeConfig(graphConfPath);
        String raftGroupPeers = (String)this.conf.get(ServerOptions.RAFT_GROUP_PEERS);
        config.addProperty(ServerOptions.RAFT_GROUP_PEERS.name(), (Object)raftGroupPeers);
        this.transferRoleWorkerConfig(config);
        Graph graph = GraphFactory.open((Configuration)config);
        this.graphs.put(name, graph);
        HugeConfig graphConfig = (HugeConfig)graph.configuration();
        assert (graphConfPath.equals(Objects.requireNonNull(graphConfig.file()).getPath()));
        LOG.info("Graph '{}' was successfully configured via '{}'", (Object)name, (Object)graphConfPath);
        if (this.requireAuthentication() && !(graph instanceof HugeGraphAuthProxy)) {
            LOG.warn("You may need to support access control for '{}' with {}", (Object)graphConfPath, (Object)"gremlin.graph=org.apache.hugegraph.auth.HugeFactoryAuthProxy");
        }
    }

    private void transferRoleWorkerConfig(HugeConfig config) {
        config.setProperty(RoleElectionOptions.NODE_EXTERNAL_URL.name(), this.conf.get(ServerOptions.REST_SERVER_URL));
        config.setProperty(RoleElectionOptions.BASE_TIMEOUT_MILLISECOND.name(), this.conf.get((TypedOption)RoleElectionOptions.BASE_TIMEOUT_MILLISECOND));
        config.setProperty(RoleElectionOptions.EXCEEDS_FAIL_COUNT.name(), this.conf.get((TypedOption)RoleElectionOptions.EXCEEDS_FAIL_COUNT));
        config.setProperty(RoleElectionOptions.RANDOM_TIMEOUT_MILLISECOND.name(), this.conf.get((TypedOption)RoleElectionOptions.RANDOM_TIMEOUT_MILLISECOND));
        config.setProperty(RoleElectionOptions.HEARTBEAT_INTERVAL_SECOND.name(), this.conf.get((TypedOption)RoleElectionOptions.HEARTBEAT_INTERVAL_SECOND));
        config.setProperty(RoleElectionOptions.MASTER_DEAD_TIMES.name(), this.conf.get((TypedOption)RoleElectionOptions.MASTER_DEAD_TIMES));
    }

    private void waitGraphsReady() {
        if (!this.rpcServer.enabled()) {
            LOG.info("RpcServer is not enabled, skip wait graphs ready");
            return;
        }
        RpcServer remotingRpcServer = this.remotingRpcServer();
        for (String graphName : this.graphs.keySet()) {
            HugeGraph graph = this.graph(graphName);
            graph.waitReady(remotingRpcServer);
        }
    }

    private void checkBackendVersionOrExit(HugeConfig config) {
        LOG.info("Check backend version");
        for (String graph : this.graphs()) {
            BackendStoreInfo info;
            HugeGraph hugegraph = this.graph(graph);
            assert (hugegraph != null);
            if (!hugegraph.backendStoreFeatures().supportsPersistence()) {
                hugegraph.initBackend();
                if (this.requireAuthentication()) {
                    String token = (String)config.get(ServerOptions.AUTH_ADMIN_TOKEN);
                    try {
                        this.authenticator().initAdminUser(token);
                    }
                    catch (Exception e) {
                        throw new BackendException("The backend store of '%s' can't initialize admin user", new Object[]{hugegraph.name()});
                    }
                }
            }
            if (!(info = hugegraph.backendStoreInfo()).exists()) {
                throw new BackendException("The backend store of '%s' has not been initialized", new Object[]{hugegraph.name()});
            }
            if (info.checkVersion()) continue;
            throw new BackendException("The backend store version is inconsistent");
        }
    }

    private void serverStarted(HugeConfig config) {
        boolean supportRoleElection;
        String id = (String)config.get(ServerOptions.SERVER_ID);
        String role = (String)config.get(ServerOptions.SERVER_ROLE);
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)"The server name can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)role), (String)"The server role can't be null or empty", (Object[])new Object[0]);
        NodeRole nodeRole = NodeRole.valueOf((String)role.toUpperCase());
        boolean bl = supportRoleElection = !nodeRole.computer() && this.supportRoleElection();
        if (supportRoleElection) {
            nodeRole = NodeRole.WORKER;
        }
        this.globalNodeRoleInfo.initNodeId(IdGenerator.of((String)id));
        this.globalNodeRoleInfo.initNodeRole(nodeRole);
        for (String graph : this.graphs()) {
            HugeGraph hugegraph = this.graph(graph);
            assert (hugegraph != null);
            hugegraph.serverStarted(this.globalNodeRoleInfo);
        }
        if (supportRoleElection) {
            this.initRoleStateMachine();
        }
    }

    private void initRoleStateMachine() {
        E.checkArgument((this.roleStateMachine == null ? 1 : 0) != 0, (String)"Repeated initialization of role state worker", (Object[])new Object[0]);
        this.globalNodeRoleInfo.supportElection(true);
        this.roleStateMachine = this.authenticator().graph().roleElectionStateMachine();
        StandardRoleListener listener = new StandardRoleListener(TaskManager.instance(), this.globalNodeRoleInfo);
        this.roleStateMachine.start((RoleListener)listener);
    }

    private boolean supportRoleElection() {
        try {
            if (!(this.authenticator() instanceof StandardAuthenticator)) {
                LOG.info("{} authenticator does not support role election currently", (Object)this.authenticator().getClass().getSimpleName());
                return false;
            }
            return true;
        }
        catch (IllegalStateException e) {
            LOG.info("{}, does not support role election currently", (Object)e.getMessage());
            return false;
        }
    }

    private void addMetrics(HugeConfig config) {
        MetricManager metric = MetricManager.INSTANCE;
        ServerReporter reporter = ServerReporter.instance(metric.getRegistry());
        reporter.start(60L, TimeUnit.SECONDS);
        int maxWriteThreads = (Integer)config.get(ServerOptions.MAX_WRITE_THREADS);
        MetricsUtil.registerGauge(RestServer.class, "max-write-threads", () -> maxWriteThreads);
        Map caches = CacheManager.instance().caches();
        GraphManager.registerCacheMetrics(caches);
        AtomicInteger lastCachesSize = new AtomicInteger(caches.size());
        MetricsUtil.registerGauge(Cache.class, "instances", () -> {
            int count = caches.size();
            if (count != lastCachesSize.get()) {
                GraphManager.registerCacheMetrics(caches);
                lastCachesSize.set(count);
            }
            return count;
        });
        MetricsUtil.registerGauge(TaskManager.class, "workers", () -> TaskManager.instance().workerPoolSize());
        MetricsUtil.registerGauge(TaskManager.class, "pending-tasks", () -> TaskManager.instance().pendingTasks());
    }

    private void listenChanges() {
        this.eventHub.listen("graph.create", event -> {
            LOG.debug("RestServer accepts event '{}'", (Object)event.name());
            event.checkArgs(new Class[]{HugeGraph.class});
            HugeGraph graph = (HugeGraph)event.args()[0];
            this.graphs.put(graph.name(), (Graph)graph);
            return null;
        });
        this.eventHub.listen("graph.drop", event -> {
            LOG.debug("RestServer accepts event '{}'", (Object)event.name());
            event.checkArgs(new Class[]{HugeGraph.class});
            HugeGraph graph = (HugeGraph)event.args()[0];
            this.graphs.remove(graph.name());
            return null;
        });
    }

    private void unlistenChanges() {
        this.eventHub.unlisten("graph.create");
        this.eventHub.unlisten("graph.drop");
    }

    private void notifyAndWaitEvent(String event, HugeGraph graph) {
        Future future = this.eventHub.notify(event, new Object[]{graph});
        try {
            future.get();
        }
        catch (Throwable e) {
            LOG.warn("Error when waiting for event execution: {}", (Object)event, (Object)e);
        }
    }

    private HugeGraph createGraph(HugeConfig config, String name) {
        HugeGraph graph = null;
        try {
            graph = (HugeGraph)GraphFactory.open((Configuration)config);
            graph.create(this.graphsDir, this.globalNodeRoleInfo);
        }
        catch (Throwable e) {
            LOG.error("Failed to create graph '{}' due to: {}", new Object[]{name, e.getMessage(), e});
            if (graph != null) {
                this.dropGraph(graph);
            }
            throw e;
        }
        this.notifyAndWaitEvent("graph.create", graph);
        return graph;
    }

    private void dropGraph(HugeGraph graph) {
        graph.drop();
        HugeFactory.remove((HugeGraph)graph);
    }

    private void checkOptions(HugeConfig config) {
        this.checkOptionUnique(config, (TypedOption<?, ?>)CoreOptions.STORE);
    }

    private void checkOptionUnique(HugeConfig config, TypedOption<?, ?> option) {
        Object incomingValue = config.get(option);
        for (String graphName : this.graphs.keySet()) {
            HugeGraph graph = this.graph(graphName);
            assert (graph != null);
            Object existedValue = graph.option(option);
            E.checkArgument((!incomingValue.equals(existedValue) ? 1 : 0) != 0, (String)"The value '%s' of option '%s' conflicts with existed graph", (Object[])new Object[]{incomingValue, option.name()});
        }
    }

    private static void registerCacheMetrics(Map<String, Cache<?, ?>> caches) {
        SortedSet names = MetricManager.INSTANCE.getRegistry().getNames();
        for (Map.Entry<String, Cache<?, ?>> entry : caches.entrySet()) {
            String key = entry.getKey();
            Cache<?, ?> cache = entry.getValue();
            String hits = String.format("%s.%s", key, "hits");
            String miss = String.format("%s.%s", key, "miss");
            String exp = String.format("%s.%s", key, "expire");
            String size = String.format("%s.%s", key, "size");
            String cap = String.format("%s.%s", key, "capacity");
            if (names.stream().anyMatch(name -> name.endsWith(hits))) continue;
            MetricsUtil.registerGauge(Cache.class, hits, () -> cache.hits());
            MetricsUtil.registerGauge(Cache.class, miss, () -> cache.miss());
            MetricsUtil.registerGauge(Cache.class, exp, () -> cache.expire());
            MetricsUtil.registerGauge(Cache.class, size, () -> cache.size());
            MetricsUtil.registerGauge(Cache.class, cap, () -> cache.capacity());
        }
    }
}

