/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.SameNeighborTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/sameneighbors")
@Singleton
@Tag(name="SameNeighborsAPI")
public class SameNeighborsAPI
extends API {
    private static final Logger LOG = Log.logger(SameNeighborsAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="vertex") String vertex, @QueryParam(value="other") String other, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="limit") @DefaultValue(value="10000000") int limit) {
        LOG.debug("Graph [{}] get same neighbors between '{}' and '{}' with direction {}, edge label {}, max degree '{}' and limit '{}'", new Object[]{graph, vertex, other, direction, edgeLabel, maxDegree, limit});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Id sourceId = VertexAPI.checkAndParseVertexId(vertex);
        Id targetId = VertexAPI.checkAndParseVertexId(other);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = SameNeighborsAPI.graph(manager, graph);
        SameNeighborTraverser traverser = new SameNeighborTraverser(g);
        Set neighbors = traverser.sameNeighbors(sourceId, targetId, dir, edgeLabel, maxDegree, limit);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        return manager.serializer((Graph)g, measure.measures()).writeList("same_neighbors", neighbors);
    }

    @POST
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String sameNeighbors(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        LOG.debug("Graph [{}] get same neighbors among batch, '{}'", (Object)graph, (Object)request.toString());
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(request.direction));
        HugeGraph g = SameNeighborsAPI.graph(manager, graph);
        SameNeighborTraverser traverser = new SameNeighborTraverser(g);
        List<Object> vertexList = request.vertexList;
        E.checkArgument((vertexList.size() >= 2 ? 1 : 0) != 0, (String)"vertex_list size can't be less than 2", (Object[])new Object[0]);
        ArrayList<Id> vertexIds = new ArrayList<Id>();
        for (Object obj : vertexList) {
            vertexIds.add(HugeVertex.getIdValue((Object)obj));
        }
        Set neighbors = traverser.sameNeighbors(vertexIds, dir, request.labels, request.maxDegree, request.limit);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        HashSet<Id> ids = new HashSet<Id>(neighbors);
        ids.addAll(vertexIds);
        Iterator iterVertex = request.withVertex && !ids.isEmpty() ? g.vertices(ids.toArray()) : ids.iterator();
        return manager.serializer((Graph)g, measure.measures()).writeMap((Map<?, ?>)ImmutableMap.of((Object)"same_neighbors", (Object)neighbors, (Object)"vertices", (Object)iterVertex));
    }

    private static class Request {
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10000000");
        @JsonProperty(value="vertex_list")
        private List<Object> vertexList;
        @JsonProperty(value="direction")
        private String direction;
        @JsonProperty(value="labels")
        private List<String> labels;
        @JsonProperty(value="with_vertex")
        private boolean withVertex = false;

        private Request() {
        }

        public String toString() {
            return String.format("SameNeighborsBatchRequest{vertex_list=%s,direction=%s,label=%s,max_degree=%d,limit=%d,with_vertex=%s", this.vertexList, this.direction, this.labels, this.maxDegree, this.limit, this.withVertex);
        }
    }
}

