/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.RateLimiter;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.define.WorkLoad;
import org.apache.hugegraph.util.E;

@Provider
@Singleton
@PreMatching
public class LoadDetectFilter
implements ContainerRequestFilter {
    private static final Set<String> WHITE_API_LIST = ImmutableSet.of((Object)"", (Object)"apis", (Object)"metrics", (Object)"versions");
    private static final RateLimiter GC_RATE_LIMITER = RateLimiter.create((double)0.03333333333333333);
    @Context
    private jakarta.inject.Provider<HugeConfig> configProvider;
    @Context
    private jakarta.inject.Provider<WorkLoad> loadProvider;

    public void filter(ContainerRequestContext context) {
        if (LoadDetectFilter.isWhiteAPI(context)) {
            return;
        }
        HugeConfig config = (HugeConfig)this.configProvider.get();
        int maxWorkerThreads = (Integer)config.get(ServerOptions.MAX_WORKER_THREADS);
        WorkLoad load = (WorkLoad)this.loadProvider.get();
        if (load.incrementAndGet() >= maxWorkerThreads) {
            throw new ServiceUnavailableException(String.format("The server is too busy to process the request, you can config %s to adjust it or try again later", ServerOptions.MAX_WORKER_THREADS.name()));
        }
        long minFreeMemory = ((Integer)config.get(ServerOptions.MIN_FREE_MEMORY)).intValue();
        long allocatedMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long presumableFreeMem = (Runtime.getRuntime().maxMemory() - allocatedMem) / 0x100000L;
        if (presumableFreeMem < minFreeMemory) {
            LoadDetectFilter.gcIfNeeded();
            throw new ServiceUnavailableException(String.format("The server available memory %s(MB) is below than threshold %s(MB) and can't process the request, you can config %s to adjust it or try again later", presumableFreeMem, minFreeMemory, ServerOptions.MIN_FREE_MEMORY.name()));
        }
    }

    public static boolean isWhiteAPI(ContainerRequestContext context) {
        List segments = context.getUriInfo().getPathSegments();
        E.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (String)"Invalid request uri '%s'", (Object[])new Object[]{context.getUriInfo().getPath()});
        String rootPath = ((PathSegment)segments.get(0)).getPath();
        return WHITE_API_LIST.contains(rootPath);
    }

    private static void gcIfNeeded() {
        if (GC_RATE_LIMITER.tryAcquire(1)) {
            System.gc();
        }
    }
}

