/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import java.util.Objects;
import org.apache.hugegraph.store.HgStoreSession;
import org.apache.hugegraph.store.client.HgStoreNode;
import org.apache.hugegraph.store.client.HgStoreNodeManager;
import org.apache.hugegraph.store.client.grpc.GrpcStoreNodeSessionImpl;
import org.apache.hugegraph.store.client.grpc.GrpcStoreSessionClient;
import org.apache.hugegraph.store.client.grpc.GrpcStoreStreamClient;

class GrpcStoreNodeImpl
implements HgStoreNode {
    private final GrpcStoreSessionClient sessionClient;
    private final GrpcStoreStreamClient streamClient;
    private final HgStoreNodeManager nodeManager;
    private String address;
    private Long nodeId;

    GrpcStoreNodeImpl(HgStoreNodeManager nodeManager, GrpcStoreSessionClient sessionClient, GrpcStoreStreamClient streamClient) {
        this.nodeManager = nodeManager;
        this.sessionClient = sessionClient;
        this.streamClient = streamClient;
    }

    @Override
    public Long getNodeId() {
        return this.nodeId;
    }

    GrpcStoreNodeImpl setNodeId(Long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    GrpcStoreNodeImpl setAddress(String address) {
        this.address = address;
        return this;
    }

    @Override
    public HgStoreSession openSession(String graphName) {
        return new GrpcStoreNodeSessionImpl(this, graphName, this.nodeManager, this.sessionClient, this.streamClient);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcStoreNodeImpl that = (GrpcStoreNodeImpl)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.nodeId, that.nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.nodeId);
    }

    public String toString() {
        return "storeNode: {address: \"" + this.address + "\", nodeId: " + this.nodeId + "}";
    }
}

