/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgKvOrderedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequencedIterator
implements HgKvIterator {
    private static final Logger log = LoggerFactory.getLogger(SequencedIterator.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Queue<HgKvOrderedIterator> queue;
    private final long limit;
    private HgKvOrderedIterator<HgKvEntry> iterator;
    private HgKvEntry entry;
    private int count;
    private byte[] position = EMPTY_BYTES;
    private byte[] position4Seeking = EMPTY_BYTES;

    SequencedIterator(List<HgKvOrderedIterator> iterators, long limit) {
        Collections.sort(iterators);
        this.queue = new LinkedList<HgKvOrderedIterator>(iterators);
        this.limit = limit <= 0L ? Integer.MAX_VALUE : limit;
    }

    private HgKvOrderedIterator getIterator() {
        HgKvOrderedIterator buf;
        if (this.queue.isEmpty()) {
            return null;
        }
        while ((buf = this.queue.poll()) != null) {
            buf.seek(this.position4Seeking);
            if (!buf.hasNext()) continue;
            break;
        }
        return buf;
    }

    private void closeIterators() {
        HgKvOrderedIterator buf;
        if (this.queue.isEmpty()) {
            return;
        }
        while ((buf = this.queue.poll()) != null) {
            buf.close();
        }
    }

    @Override
    public byte[] key() {
        if (this.entry != null) {
            return this.entry.key();
        }
        return null;
    }

    @Override
    public byte[] value() {
        if (this.entry != null) {
            return this.entry.value();
        }
        return null;
    }

    @Override
    public byte[] position() {
        return this.position;
    }

    @Override
    public void seek(byte[] pos) {
        if (pos != null) {
            this.position4Seeking = pos;
        }
    }

    @Override
    public boolean hasNext() {
        if ((long)this.count >= this.limit) {
            return false;
        }
        if (this.iterator == null) {
            this.iterator = this.getIterator();
        } else if (!this.iterator.hasNext()) {
            this.iterator.close();
            this.iterator = this.getIterator();
        }
        return this.iterator != null;
    }

    @Override
    public Object next() {
        if (this.iterator == null) {
            this.hasNext();
        }
        if (this.iterator == null) {
            throw new NoSuchElementException();
        }
        this.entry = (HgKvEntry)this.iterator.next();
        this.position = this.iterator.position();
        if (!this.iterator.hasNext()) {
            this.iterator.close();
            this.iterator = null;
        }
        ++this.count;
        return this.entry;
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.closeIterators();
    }
}

