/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

public class TermSelector
extends Selector {
    private final ByteBuffer value;
    private final AbstractType<?> type;

    public static Selector.Factory newFactory(final String name, final Term term, final AbstractType<?> type) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return name;
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultColumn) {
                mapping.addMapping(resultColumn, (ColumnMetadata)null);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new TermSelector(term.bindAndGet(options), type);
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return true;
            }
        };
    }

    private TermSelector(ByteBuffer value, AbstractType<?> type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        return this.value;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    @Override
    public void reset() {
    }
}

