/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output;

import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.output.ComputerOutput;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class AbstractComputerOutput
implements ComputerOutput {
    private static final Logger LOG = Log.logger(ComputerOutput.class);
    private String name;
    private int partition;

    @Override
    public void init(Config config, int partition) {
        Computation computation = (Computation)config.createObject(ComputerOptions.WORKER_COMPUTATION_CLASS);
        this.name = computation.name();
        this.partition = partition;
        LOG.info("Start write back partition {} for {}", (Object)this.partition(), (Object)this.name());
    }

    @Override
    public String name() {
        return this.name;
    }

    public int partition() {
        return this.partition;
    }
}

