/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Command;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.Field;
import com.xugu.cloudjdbc.LogWriter;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import java.sql.SQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    private Field[] fields = null;
    private boolean isOrcl;
    private Connection curConn;

    ResultSetMetaData(Field[] fields, boolean isOracle, Connection conn) {
        this.fields = fields;
        this.isOrcl = isOracle;
        this.curConn = conn;
    }

    private Field getField(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkFieldsOpen();
        return this.fields[columnIndex - 1];
    }

    public static final boolean isDecimalType(int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.checkFieldsOpen();
        int i = 0;
        for (int j = 0; j < this.fields.length; ++j) {
            if (this.fields[j].isHide()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        return field.isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3100: 
            case 3200: {
                return false;
            }
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3100: 
            case 3200: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkFieldsOpen();
        if (this.getField(column).isNotNull()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        int sqlType = field.getSQLType();
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return field.isSigned();
            }
            case 91: 
            case 92: 
            case 93: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        switch (field.getRedhorseType()) {
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return 22;
            }
            case 34: {
                return 4000;
            }
        }
        return this.getPrecision(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkFieldsOpen();
        if (this.getField(column).getColumnLabel() != null) {
            return this.getField(column).getColumnLabel();
        }
        return this.getField(column).getColumnName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkFieldsOpen();
        if (Command.debug && (Command.debugLevel.equals("ALL") || Command.debugLevel.indexOf("beginNormal") != -1)) {
            this.curConn.io.lw.write(this.curConn.io.sessionId, "ResultSetMetaData getColumnName : " + this.fields[column - 1], LogWriter.CmdState.rsMethod);
        }
        Field field = this.getField(column);
        if (this.isOrcl) {
            return this.getColumnLabel(column);
        }
        if (field != null) {
            return field.getColumnName();
        }
        return "";
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        Field field = this.getField(column);
        return field.getTableSchema();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        int precision = field.getPrecision();
        if (precision == -1) {
            switch (field.getRedhorseType()) {
                case 5: 
                case 8: {
                    precision = 4;
                    break;
                }
                case 6: 
                case 9: {
                    precision = 8;
                    break;
                }
                case 4: {
                    precision = 2;
                    break;
                }
                case 3: {
                    precision = 1;
                    break;
                }
                case 30: 
                case 32: 
                case 34: 
                case 62: 
                case 63: {
                    precision = -1;
                    break;
                }
                default: {
                    precision = 2048;
                }
            }
        }
        return precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        if (ResultSetMetaData.isDecimalType(field.getSQLType())) {
            return field.getScale();
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkFieldsOpen();
        return this.getField(column).getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        String database = field.getDatabaseName();
        return database == null ? "" : database;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkFieldsOpen();
        int columnType = this.getField(column).getSQLType();
        if (this.curConn.isora && columnType == -5) {
            columnType = 2;
        }
        return columnType;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        return TypesUtil.getRedhorseTypeName(field.getRedhorseType());
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkFieldsOpen();
        return this.getField(column).isReadOnly();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkFieldsOpen();
        Field field = this.getField(column);
        int redhorseType = field.getRedhorseType();
        return TypesUtil.getClassName(redhorseType);
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        return false;
    }

    public Object unwrap(Class arg0) throws SQLException {
        return null;
    }

    void checkFieldsOpen() throws SQLException {
        if (this.fields == null || this.fields.length == 0 || this.fields[0] == null) {
            throw Error.createSQLException("[E52001]\u65e0\u6cd5\u67e5\u8be2\u7ed3\u679c\u96c6\u5217\u4fe1\u606f", ReplaceEnum.excStr.getReplaceStr() + 52001, 52001);
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw Error.createSQLException("[E50042]ResultSet: Column Index out of range" + columnIndex, ReplaceEnum.excStr.getReplaceStr() + 50042, 50042);
        }
    }
}

