/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import java.util.Collections;
import java.util.List;

public class ClickHouseSimpleRecord
implements ClickHouseRecord {
    public static final ClickHouseSimpleRecord EMPTY = new ClickHouseSimpleRecord(Collections.emptyList(), new ClickHouseValue[0]);
    private final List<ClickHouseColumn> columns;
    private ClickHouseValue[] values;

    public static ClickHouseRecord of(List<ClickHouseColumn> columns, ClickHouseValue[] values) {
        if (columns == null || values == null) {
            throw new IllegalArgumentException("Non-null columns and values are required");
        }
        if (columns.size() != values.length) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Mismatched count: we have %d columns but we got %d values", columns.size(), values.length));
        }
        if (values.length == 0) {
            return EMPTY;
        }
        return new ClickHouseSimpleRecord(columns, values);
    }

    protected ClickHouseSimpleRecord(List<ClickHouseColumn> columns, ClickHouseValue[] values) {
        this.columns = columns;
        this.values = values;
    }

    protected List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    protected ClickHouseValue[] getValues() {
        return this.values;
    }

    protected void update(ClickHouseValue[] values) {
        this.values = values;
    }

    protected void update(Object[] values) {
        int len = values != null ? values.length : 0;
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            if (i < len) {
                this.values[i].update(values[i]);
                continue;
            }
            this.values[i].resetToNullOrEmpty();
        }
    }

    @Override
    public ClickHouseRecord copy() {
        if (this == EMPTY) {
            return EMPTY;
        }
        int len = this.values.length;
        ClickHouseValue[] vals = new ClickHouseValue[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.values[i].copy();
        }
        return new ClickHouseSimpleRecord(this.columns, vals);
    }

    @Override
    public ClickHouseValue getValue(int index) {
        return this.values[index];
    }

    @Override
    public ClickHouseValue getValue(String name) {
        int index = 0;
        for (ClickHouseColumn c : this.columns) {
            if (c.getColumnName().equalsIgnoreCase(name)) {
                return this.getValue(index);
            }
            ++index;
        }
        throw new IllegalArgumentException(ClickHouseUtils.format("Unable to find column [%s]", name));
    }

    @Override
    public int size() {
        return this.values.length;
    }
}

