/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.InMemoryStorage;
import com.keepersecurity.secretsManager.core.KeyValueStorage;
import com.keepersecurity.secretsManager.core.SecretsManager;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.form.TextField;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.vault.conf.VaultAttributeService;
import org.apache.guacamole.vault.ksm.conf.KsmConfig;
import org.apache.guacamole.vault.ksm.conf.KsmConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KsmAttributeService
implements VaultAttributeService {
    private static final Logger logger = LoggerFactory.getLogger(KsmAttributeService.class);
    @Inject
    private KsmConfigurationService configurationService;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final List<String> EXPECTED_KSM_FIELDS = Collections.unmodifiableList(Arrays.asList("hostname", "clientId", "privateKey", "clientKey", "appKey", "appOwnerPublicKey", "serverPublicKeyId"));
    public static final String KSM_CONFIGURATION_ATTRIBUTE = "ksm-config";
    public static final String KSM_ATTRIBUTE_PLACEHOLDER_VALUE = "**********";
    public static final Form KSM_CONFIGURATION_FORM = new Form("ksm-config", Arrays.asList(new TextField("ksm-config")));
    public static final Collection<Form> KSM_ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(KSM_CONFIGURATION_FORM));
    public static final String KSM_USER_CONFIG_ENABLED_ATTRIBUTE = "ksm-user-config-enabled";
    public static final String TRUTH_VALUE = "true";
    public static final Form KSM_CONNECTION_FORM = new Form("ksm-config", Arrays.asList(new BooleanField("ksm-user-config-enabled", "true")));
    public static final Collection<Form> KSM_CONNECTION_ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(KSM_CONNECTION_FORM));

    public Collection<Form> getConnectionAttributes() {
        return KSM_CONNECTION_ATTRIBUTES;
    }

    public Collection<Form> getConnectionGroupAttributes() {
        return KSM_ATTRIBUTES;
    }

    public Collection<Form> getUserAttributes() {
        try {
            return this.configurationService.getAllowUserConfig() ? KSM_ATTRIBUTES : Collections.emptyList();
        }
        catch (GuacamoleException e) {
            logger.warn("Unable to determine if KSM user attributes should be exposed due to config parsing error: {}.", (Object)e.getMessage());
            logger.debug("Config parsing error prevented checking user attribute configuration", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Collection<Form> getUserPreferenceAttributes() {
        return this.getUserAttributes();
    }

    public static String sanitizeKsmAttributeValue(String ksmAttributeValue) {
        if (ksmAttributeValue != null && !ksmAttributeValue.trim().isEmpty()) {
            return KSM_ATTRIBUTE_PLACEHOLDER_VALUE;
        }
        return null;
    }

    private static boolean isBase64(String input) {
        try {
            Base64.getDecoder().decode(input);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Map<String, String> processAttributes(Map<String, String> attributes) throws GuacamoleException {
        String ksmConfigValue = attributes.get(KSM_CONFIGURATION_ATTRIBUTE);
        if (KSM_ATTRIBUTE_PLACEHOLDER_VALUE.equals(ksmConfigValue)) {
            attributes = new HashMap<String, String>(attributes);
            attributes.remove(KSM_CONFIGURATION_ATTRIBUTE);
        } else if (ksmConfigValue != null && !ksmConfigValue.trim().isEmpty()) {
            if (KsmAttributeService.isBase64(ksmConfigValue)) {
                try {
                    KsmConfig.parseKsmConfig(ksmConfigValue);
                    return attributes;
                }
                catch (GuacamoleException exception) {
                    throw new TranslatableGuacamoleClientException("Invalid base64-encoded JSON KSM config provided for ksm-config attribute", "CONNECTION_GROUP_ATTRIBUTES.ERROR_INVALID_KSM_CONFIG_BLOB", (Throwable)exception);
                }
            }
            try {
                InMemoryStorage storage = new InMemoryStorage();
                SecretsManager.initializeStorage((KeyValueStorage)storage, (String)ksmConfigValue, null);
                SecretsManagerOptions options = new SecretsManagerOptions((KeyValueStorage)storage, null, this.configurationService.getAllowUnverifiedCertificate());
                SecretsManager.getSecrets((SecretsManagerOptions)options);
                HashMap configMap = new HashMap();
                EXPECTED_KSM_FIELDS.forEach(configKey -> {
                    String value = storage.getString(configKey);
                    if (value != null) {
                        configMap.put(configKey, value);
                    }
                });
                String jsonString = objectMapper.writeValueAsString(configMap);
                String base64EncodedJson = Base64.getEncoder().encodeToString(jsonString.getBytes(StandardCharsets.UTF_8));
                KsmConfig.parseKsmConfig(base64EncodedJson);
                attributes = new HashMap<String, String>(attributes);
                attributes.put(KSM_CONFIGURATION_ATTRIBUTE, base64EncodedJson);
            }
            catch (Exception exception) {
                throw new TranslatableGuacamoleClientException("Invalid one-time KSM token provided for ksm-config attribute", "CONNECTION_GROUP_ATTRIBUTES.ERROR_INVALID_KSM_ONE_TIME_TOKEN", (Throwable)exception);
            }
        }
        return attributes;
    }
}

