/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.history.connection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.history.HistoryAuthenticationProvider;
import org.apache.guacamole.io.ReaderGuacamoleReader;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.ActivityLog;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.DelegatingConnectionRecord;
import org.apache.guacamole.net.auth.FileActivityLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryConnectionRecord
extends DelegatingConnectionRecord {
    private static final Logger logger = LoggerFactory.getLogger(HistoryConnectionRecord.class);
    private static final UUID UUID_NAMESPACE_URL = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    private static final String TIMING_FILE_SUFFIX = ".timing";
    private final File recording;

    private static File getRecordingFile(ConnectionRecord record) throws GuacamoleException {
        File recordingFile;
        UUID uuid = record.getUUID();
        if (uuid != null && (recordingFile = new File(HistoryAuthenticationProvider.getRecordingSearchPath(), uuid.toString())).canRead()) {
            return recordingFile;
        }
        return null;
    }

    public HistoryConnectionRecord(ConnectionRecord record) throws GuacamoleException {
        super(record);
        this.recording = HistoryConnectionRecord.getRecordingFile(record);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSessionRecording(File file) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            ReaderGuacamoleReader guacReader = new ReaderGuacamoleReader((Reader)reader);
            if (guacReader.readInstruction() == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (GuacamoleException e) {
            logger.debug("File \"{}\" does not appear to be a session recording, as it could not be parsed as Guacamole protocol data.", (Object)file, (Object)e);
            return false;
        }
        catch (IOException e) {
            logger.warn("Possible session recording \"{}\" could not be identified as it cannot be read: {}", (Object)file, (Object)e.getMessage());
            logger.debug("Possible session recording \"{}\" could not be read.", (Object)file, (Object)e);
        }
        return false;
    }

    private boolean isTypescript(File file) {
        return new File(file.getAbsolutePath() + TIMING_FILE_SUFFIX).exists();
    }

    private boolean isTypescriptTiming(File file) {
        return file.getName().endsWith(TIMING_FILE_SUFFIX);
    }

    private ActivityLog.Type getType(File file) {
        if (this.isSessionRecording(file)) {
            return ActivityLog.Type.GUACAMOLE_SESSION_RECORDING;
        }
        if (this.isTypescript(file)) {
            return ActivityLog.Type.TYPESCRIPT;
        }
        if (this.isTypescriptTiming(file)) {
            return ActivityLog.Type.TYPESCRIPT_TIMING;
        }
        return ActivityLog.Type.SERVER_LOG;
    }

    private ActivityLog getActivityLog(File file) {
        if (!file.canRead()) {
            logger.warn("Ignoring file \"{}\" relevant to connection history record as it cannot be read.", (Object)file);
            return null;
        }
        ActivityLog.Type logType = this.getType(file);
        if (logType == null) {
            logger.warn("Recording/log type of \"{}\" cannot be determined.", (Object)file);
            return null;
        }
        return new FileActivityLog(logType, new TranslatableMessage("RECORDING_STORAGE.INFO_" + logType.name()), file);
    }

    private void addActivityLog(Map<String, ActivityLog> logs, File file) {
        UUID fileUUID;
        ActivityLog log = this.getActivityLog(file);
        if (log == null) {
            return;
        }
        try {
            byte[] urlBytes = file.toURI().toURL().toString().getBytes(StandardCharsets.UTF_8);
            fileUUID = UUID.nameUUIDFromBytes(ByteBuffer.allocate(16 + urlBytes.length).putLong(UUID_NAMESPACE_URL.getMostSignificantBits()).putLong(UUID_NAMESPACE_URL.getLeastSignificantBits()).put(urlBytes).array());
        }
        catch (MalformedURLException e) {
            logger.warn("Ignoring file \"{}\" as a unique URL and UUID for that file could not be generated: {}", (Object)e.getMessage());
            logger.debug("URL for file \"{}\" could not be determined.", (Object)file, (Object)e);
            return;
        }
        logs.put(fileUUID.toString(), log);
    }

    public Map<String, ActivityLog> getLogs() {
        if (this.recording == null) {
            return super.getLogs();
        }
        HashMap<String, ActivityLog> logs = new HashMap<String, ActivityLog>(super.getLogs());
        if (this.recording.isDirectory()) {
            Arrays.asList(this.recording.listFiles()).stream().forEach(file -> this.addActivityLog((Map<String, ActivityLog>)logs, (File)file));
        } else {
            this.addActivityLog(logs, this.recording);
        }
        return logs;
    }
}

