/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GrailsWrapperRepo {
    private String baseUrl;
    private String repoPath;
    private String metadataName;
    boolean isFile;

    private GrailsWrapperRepo() {
    }

    String getUrl() {
        return this.join(this.baseUrl, this.repoPath);
    }

    String getRootMetadataUrl() {
        return this.join(this.getUrl(), this.metadataName);
    }

    String getMetadataUrl(GrailsVersion version) {
        return this.join(this.getUrl(), version.version, this.metadataName);
    }

    String getFileUrl(GrailsVersion version, String name) {
        return this.join(this.getUrl(), version.version, name);
    }

    private String join(String ... elements) {
        return String.join((CharSequence)(this.isFile ? File.separator : "/"), elements);
    }

    static List<GrailsWrapperRepo> getSelectedRepos() {
        ArrayList<GrailsWrapperRepo> repos = new ArrayList<GrailsWrapperRepo>();
        for (String overRepoUrl : GrailsWrapperRepo.getOverriddenMavenRepos()) {
            if (overRepoUrl == null) continue;
            System.out.println("...Update Repository is overridden to prefer [" + overRepoUrl + "].");
            repos.add(GrailsWrapperRepo.createGrailsWrapperRepo(overRepoUrl));
        }
        repos.add(GrailsWrapperRepo.createGrailsWrapperRepo("https://repo1.maven.org/maven2"));
        repos.add(GrailsWrapperRepo.createGrailsWrapperRepo("https://repository.apache.org/content/groups/public"));
        return repos;
    }

    private static GrailsWrapperRepo createGrailsWrapperRepo(String urlOrFile) {
        GrailsWrapperRepo repo = new GrailsWrapperRepo();
        repo.repoPath = "org/apache/grails/grails-cli";
        repo.baseUrl = urlOrFile;
        boolean bl = repo.isFile = !repo.baseUrl.startsWith("http");
        if (repo.isFile && repo.baseUrl.endsWith(File.separator) || !repo.isFile && repo.baseUrl.endsWith("/")) {
            repo.baseUrl = repo.baseUrl.substring(0, repo.baseUrl.length() - 1);
        }
        repo.metadataName = repo.isFile ? "maven-metadata-local.xml" : "maven-metadata.xml";
        return repo;
    }

    static List<String> getOverriddenMavenRepos() {
        String baseUrl = System.getProperty("grails.repo.url");
        if (baseUrl != null) {
            return Arrays.stream(baseUrl.split(";")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
        String envBasedUrl = System.getenv("GRAILS_REPO_URL");
        if (envBasedUrl != null) {
            return Arrays.stream(envBasedUrl.split(";")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
        return new ArrayList<String>();
    }
}

