/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.template;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.grails.forge.template.Template;

public class PropertiesTemplate
implements Template {
    private final String path;
    private final Properties properties;

    public PropertiesTemplate(String path, Map<String, Object> config) {
        this.path = path;
        this.properties = this.transform((Properties)new LinkedProperties(), "", config);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.properties.store(outputStream, null);
    }

    private Properties transform(Properties finalConfig, String prefix, Map<String, Object> config) {
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            this.transform(finalConfig, prefix + entry.getKey(), entry.getValue());
        }
        return finalConfig;
    }

    private void transform(Properties finalConfig, String prefix, Object value) {
        if (value instanceof Map) {
            this.transform(finalConfig, prefix + ".", (Map)value);
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.transform(finalConfig, prefix + "[" + i2 + "]", list.get(i2));
            }
        } else {
            finalConfig.put(prefix, value.toString());
        }
    }

    public class LinkedProperties
    extends Properties {
        private final HashSet<Object> keys = new LinkedHashSet<Object>();

        public Iterable<Object> orderedKeys() {
            return Collections.list(this.keys());
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

