/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics.MetricsMBean;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics.MetricsMBeanImpl;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyMetrics
implements Metrics {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyMetrics.class);
    private static final MetricsMBean metrics = new MetricsMBeanImpl();
    private static final ObjectName oname;
    private static final ThreadLocal<HashMap<String, LegacyMetricsScope>> threadLocalScopes;

    private LegacyMetrics() {
    }

    public LegacyMetrics(HiveConf conf) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.registerMBean(metrics, oname);
    }

    @Override
    public Long incrementCounter(String name) {
        return this.incrementCounter(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrementCounter(String name, long increment) {
        Long value = null;
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (!metrics.hasKey(name)) {
                value = increment;
                this.set(name, value);
            } else {
                try {
                    value = (Long)this.get(name) + increment;
                    this.set(name, value);
                }
                catch (JMException e) {
                    LOG.warn("Could not find counter value for " + name + ", increment operation skipped.", (Throwable)e);
                }
            }
        }
        return value;
    }

    @Override
    public Long decrementCounter(String name) {
        return this.decrementCounter(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrementCounter(String name, long decrement) {
        Long value = null;
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (!metrics.hasKey(name)) {
                value = decrement;
                this.set(name, -value.longValue());
            } else {
                try {
                    value = (Long)this.get(name) - decrement;
                    this.set(name, value);
                }
                catch (JMException e) {
                    LOG.warn("Could not find counter value for " + name + ", decrement operation skipped.", (Throwable)e);
                }
            }
        }
        return value;
    }

    @Override
    public void addGauge(String name, MetricsVariable variable) {
    }

    @Override
    public void addRatio(String name, MetricsVariable<Integer> numerator, MetricsVariable<Integer> denominator) {
    }

    @Override
    public void markMeter(String name) {
    }

    public void set(String name, Object value) {
        metrics.put(name, value);
    }

    public Object get(String name) throws JMException {
        return metrics.get(name);
    }

    @Override
    public void startStoredScope(String name) {
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).open();
        } else {
            threadLocalScopes.get().put(name, new LegacyMetricsScope(name, this));
        }
    }

    public MetricsScope getStoredScope(String name) throws IllegalStateException {
        if (threadLocalScopes.get().containsKey(name)) {
            return threadLocalScopes.get().get(name);
        }
        throw new IllegalStateException("No metrics scope named " + name);
    }

    @Override
    public void endStoredScope(String name) {
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).close();
        }
    }

    @Override
    public MetricsScope createScope(String name) {
        return new LegacyMetricsScope(name, this);
    }

    @Override
    public void endScope(MetricsScope scope) {
        ((LegacyMetricsScope)scope).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(oname)) {
                mbs.unregisterMBean(oname);
            }
            metrics.clear();
            threadLocalScopes.remove();
        }
    }

    static {
        try {
            oname = new ObjectName("org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.metrics:type=MetricsMBean");
        }
        catch (MalformedObjectNameException mone) {
            throw new RuntimeException(mone);
        }
        threadLocalScopes = new ThreadLocal<HashMap<String, LegacyMetricsScope>>(){

            @Override
            protected HashMap<String, LegacyMetricsScope> initialValue() {
                return new HashMap<String, LegacyMetricsScope>();
            }
        };
    }

    public static class LegacyMetricsScope
    implements MetricsScope {
        private final LegacyMetrics metrics;
        private final String name;
        private final String numCounter;
        private final String timeCounter;
        private final String avgTimeCounter;
        private boolean isOpen = false;
        private Long startTime = null;

        private LegacyMetricsScope(String name, LegacyMetrics metrics) {
            this.metrics = metrics;
            this.name = name;
            this.numCounter = name + ".n";
            this.timeCounter = name + ".t";
            this.avgTimeCounter = name + ".avg_t";
            this.open();
        }

        public Long getNumCounter() {
            try {
                return (Long)this.metrics.get(this.numCounter);
            }
            catch (JMException e) {
                LOG.warn("Could not find counter value for " + this.numCounter + ", returning null instead. ", (Throwable)e);
                return null;
            }
        }

        public Long getTimeCounter() {
            try {
                return (Long)this.metrics.get(this.timeCounter);
            }
            catch (JMException e) {
                LOG.warn("Could not find timer value for " + this.timeCounter + ", returning null instead. ", (Throwable)e);
                return null;
            }
        }

        public void open() {
            if (!this.isOpen) {
                this.isOpen = true;
                this.startTime = System.currentTimeMillis();
            } else {
                LOG.warn("Scope named " + this.name + " is not closed, cannot be opened.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.isOpen) {
                Long endTime = System.currentTimeMillis();
                LegacyMetrics legacyMetrics = this.metrics;
                synchronized (legacyMetrics) {
                    Long num = this.metrics.incrementCounter(this.numCounter);
                    Long time = this.metrics.incrementCounter(this.timeCounter, endTime - this.startTime);
                    if (num != null && time != null) {
                        this.metrics.set(this.avgTimeCounter, time.doubleValue() / num.doubleValue());
                    }
                }
            } else {
                LOG.warn("Scope named " + this.name + " is not open, cannot be closed.");
            }
            this.isOpen = false;
        }

        public void reopen() {
            if (this.isOpen) {
                this.close();
            }
            this.open();
        }
    }
}

