/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amfx;

import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import flex.messaging.io.amfx.AmfxOutput;
import flex.messaging.io.amfx.AmfxTypes;
import java.io.IOException;
import java.io.OutputStream;

public class AmfxMessageSerializer
implements MessageSerializer,
AmfxTypes {
    protected AmfxOutput amfxOut;
    protected int version;
    protected boolean isDebug;
    protected AmfTrace debugTrace;
    public static final String XML_DIRECTIVE = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";

    @Override
    public void setVersion(int value) {
        this.version = value;
    }

    @Override
    public void initialize(SerializationContext context, OutputStream out, AmfTrace trace) {
        this.amfxOut = new AmfxOutput(context);
        this.amfxOut.setOutputStream(out);
        this.debugTrace = trace;
        this.isDebug = this.debugTrace != null;
        this.amfxOut.setDebugTrace(trace);
    }

    @Override
    public void writeMessage(ActionMessage m) throws IOException {
        if (this.isDebug) {
            this.debugTrace.startResponse("Serializing AMFX/HTTP response");
        }
        this.amfxOut.writeUTF(XML_DIRECTIVE);
        int version = m.getVersion();
        this.writeOpenAMFX(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = m.getHeaderCount();
        for (int i = 0; i < headerCount; ++i) {
            MessageHeader header = m.getHeader(i);
            if (this.isDebug) {
                this.debugTrace.startHeader(header.getName(), header.getMustUnderstand(), i);
            }
            this.writeHeader(header);
            if (!this.isDebug) continue;
            this.debugTrace.endHeader();
        }
        int bodyCount = m.getBodyCount();
        for (int i = 0; i < bodyCount; ++i) {
            MessageBody body = m.getBody(i);
            if (this.isDebug) {
                this.debugTrace.startMessage(body.getTargetURI(), body.getResponseURI(), i);
            }
            this.writeBody(body);
            if (!this.isDebug) continue;
            this.debugTrace.endMessage();
        }
        this.writeCloseAMFX();
        if (this.isDebug) {
            this.debugTrace.endMessage();
        }
    }

    protected void writeOpenAMFX(int version) throws IOException {
        int buflen = 14;
        StringBuffer sb = new StringBuffer(buflen);
        sb.append("<").append("amfx").append(" ver=\"");
        sb.append(version);
        sb.append("\">");
        this.amfxOut.writeUTF(sb);
    }

    protected void writeCloseAMFX() throws IOException {
        this.amfxOut.writeUTF("</amfx>");
    }

    protected void writeHeader(MessageHeader h) throws IOException {
        int buflen = 127;
        StringBuffer sb = new StringBuffer(buflen);
        sb.append("<").append("header").append(" name=\"");
        sb.append(h.getName());
        sb.append("\"");
        if (h.getMustUnderstand()) {
            sb.append(" mustUnderstand=\"");
            sb.append(h.getMustUnderstand());
            sb.append("\"");
        }
        sb.append(">");
        this.amfxOut.writeUTF(sb);
        this.writeObject(h.getData());
        this.amfxOut.writeUTF("</header>");
    }

    protected void writeBody(MessageBody b) throws IOException {
        if (b.getTargetURI() == null && b.getResponseURI() == null) {
            this.amfxOut.writeUTF("<body>");
        } else {
            int buflen = 127;
            StringBuffer sb = new StringBuffer(buflen);
            sb.append("<").append("body");
            if (b.getTargetURI() != null) {
                sb.append(" targetURI=\"").append(b.getTargetURI()).append("\"");
            }
            if (b.getResponseURI() != null) {
                sb.append(" responseURI=\"").append(b.getResponseURI()).append("\"");
            }
            sb.append(">");
            this.amfxOut.writeUTF(sb);
        }
        Object data = b.getData();
        this.writeObject(data);
        this.amfxOut.writeUTF("</body>");
    }

    @Override
    public void writeObject(Object value) throws IOException {
        this.amfxOut.writeObject(value);
    }
}

