/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class CreateSequenceNode
extends DDLStatementNode {
    private TableName _sequenceName;
    private DataTypeDescriptor _dataType;
    private Long _initialValue;
    private Long _stepValue;
    private Long _maxValue;
    private Long _minValue;
    private boolean _cycle;
    public static final int SEQUENCE_ELEMENT_COUNT = 1;

    CreateSequenceNode(TableName sequenceName, DataTypeDescriptor dataType, Long initialValue, Long stepValue, Long maxValue, Long minValue, boolean cycle, ContextManager cm) throws StandardException {
        super(sequenceName, cm);
        this._sequenceName = sequenceName;
        this._dataType = dataType != null ? dataType : DataTypeDescriptor.INTEGER;
        Long l = this._stepValue = stepValue != null ? stepValue : Long.valueOf(1L);
        if (this._dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            this._minValue = minValue != null ? minValue : Long.valueOf(-32768L);
            this._maxValue = maxValue != null ? maxValue : Long.valueOf(32767L);
        } else if (this._dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            this._minValue = minValue != null ? minValue : Long.valueOf(Integer.MIN_VALUE);
            this._maxValue = maxValue != null ? maxValue : Long.valueOf(Integer.MAX_VALUE);
        } else {
            this._minValue = minValue != null ? minValue : Long.MIN_VALUE;
            this._maxValue = maxValue != null ? maxValue : Long.MAX_VALUE;
        }
        this._initialValue = initialValue != null ? initialValue : (this._stepValue > 0L ? this._minValue : this._maxValue);
        this._cycle = cycle;
        this.implicitCreateSchema = true;
    }

    @Override
    public String toString() {
        return super.toString() + "sequenceName: \n" + String.valueOf(this._sequenceName) + "\n";
    }

    @Override
    public void bindStatement() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor();
        if (this._sequenceName.getSchemaName() == null) {
            this._sequenceName.setSchemaName(sd.getSchemaName());
        }
        if (this._dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            if (this._minValue < -32768L || this._minValue >= 32767L) {
                throw StandardException.newException("42XAE", "MINVALUE", "SMALLINT", "-32768", "32767");
            }
            if (this._maxValue <= -32768L || this._maxValue > 32767L) {
                throw StandardException.newException("42XAE", "MAXVALUE", "SMALLINT", "-32768", "32767");
            }
        } else if (this._dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            if (this._minValue < Integer.MIN_VALUE || this._minValue >= Integer.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MINVALUE", "INTEGER", "-2147483648", "2147483647");
            }
            if (this._maxValue <= Integer.MIN_VALUE || this._maxValue > Integer.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MAXVALUE", "INTEGER", "-2147483648", "2147483647");
            }
        } else {
            if (this._minValue < Long.MIN_VALUE || this._minValue >= Long.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MINVALUE", "BIGINT", "-9223372036854775808", "9223372036854775807");
            }
            if (this._maxValue <= Long.MIN_VALUE || this._maxValue > Long.MAX_VALUE) {
                throw StandardException.newException("42XAE", "MAXVALUE", "BIGINT", "-9223372036854775808", "9223372036854775807");
            }
        }
        if (this._minValue >= this._maxValue) {
            throw StandardException.newException("42XAF", this._minValue.toString(), this._maxValue.toString());
        }
        if (this._initialValue < this._minValue || this._initialValue > this._maxValue) {
            throw StandardException.newException("42XAG", this._initialValue.toString(), this._minValue.toString(), this._maxValue.toString());
        }
        if (this._stepValue == 0L) {
            throw StandardException.newException("42XAC", new Object[0]);
        }
    }

    @Override
    public String statementToString() {
        return "CREATE SEQUENCE";
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getCreateSequenceConstantAction(this._sequenceName, this._dataType, this._initialValue, this._stepValue, this._maxValue, this._minValue, this._cycle);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this._sequenceName != null) {
            this._sequenceName = (TableName)this._sequenceName.accept(v);
        }
    }
}

