/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public final class NetworkServerTestSetup
extends BaseTestSetup {
    private static final long DEFAULT_WAIT_TIME = 240000L;
    private static final long WAIT_TIME;
    private static final int SLEEP_TIME = 100;
    public static final String HOST_OPTION = "-h";
    private static long waitTime;
    private FileOutputStream serverOutput;
    private final boolean asCommand;
    private final boolean startServerAtSetup;
    private final boolean useSeparateProcess;
    private final boolean serverShouldComeUp;
    private final String[] systemProperties;
    private final String moduleOrClassPath;
    private final boolean useModules;
    private final boolean suppressServerDiagnostics;
    private String[] startupArgs;
    private SpawnedProcess spawnedServer;
    private NetworkServerControl networkServerController;

    public NetworkServerTestSetup(Test test, boolean asCommand) {
        super(test);
        this.asCommand = asCommand;
        this.systemProperties = null;
        this.startupArgs = null;
        this.useSeparateProcess = false;
        this.serverShouldComeUp = true;
        this.startServerAtSetup = true;
        this.moduleOrClassPath = null;
        this.useModules = false;
        this.suppressServerDiagnostics = false;
    }

    public NetworkServerTestSetup(Test test, boolean asCommand, boolean startServerAtSetup) {
        super(test);
        this.asCommand = asCommand;
        this.systemProperties = null;
        this.startupArgs = null;
        this.useSeparateProcess = false;
        this.serverShouldComeUp = true;
        this.startServerAtSetup = startServerAtSetup;
        this.moduleOrClassPath = null;
        this.useModules = false;
        this.suppressServerDiagnostics = false;
    }

    public NetworkServerTestSetup(Test test, String[] systemProperties, String[] startupArgs, boolean serverShouldComeUp) {
        this(test, systemProperties, startupArgs, serverShouldComeUp, null, JVMInfo.isModuleAware(), false);
    }

    public NetworkServerTestSetup(Test test, String[] systemProperties, String[] startupArgs, boolean serverShouldComeUp, String moduleOrClassPath, boolean useModules, boolean suppressServerDiagnostics) {
        super(test);
        this.asCommand = true;
        this.systemProperties = systemProperties;
        this.startupArgs = startupArgs;
        this.useSeparateProcess = true;
        this.serverShouldComeUp = serverShouldComeUp;
        this.startServerAtSetup = true;
        this.moduleOrClassPath = moduleOrClassPath;
        this.useModules = useModules;
        this.suppressServerDiagnostics = suppressServerDiagnostics;
    }

    protected void setUp() throws Exception {
        BaseTestCase.println("Starting network server:");
        this.networkServerController = NetworkServerTestSetup.getNetworkServerControl();
        if (this.startServerAtSetup) {
            NetworkServerTestSetup.waitForAvailablePort();
            if (this.useSeparateProcess) {
                this.spawnedServer = this.startSeparateProcess();
            } else if (this.asCommand) {
                this.startWithCommand();
            } else {
                this.startWithAPI();
            }
            if (this.serverShouldComeUp && !NetworkServerTestSetup.pingForServerStart(this.networkServerController)) {
                String msg = NetworkServerTestSetup.getTimeoutErrorMsg("network server to start");
                if (this.spawnedServer != null) {
                    this.spawnedServer.complete(2000L);
                    msg = this.spawnedServer.getFailMessage(msg);
                    this.spawnedServer = null;
                }
                JVMInfo.javaDump();
                NetworkServerTestSetup.fail((String)(msg + Utilities.NL + ExceptionUtil.dumpThreads()));
            }
        }
    }

    public static void waitForAvailablePort() throws InterruptedException, UnknownHostException {
        NetworkServerTestSetup.waitForAvailablePort(TestConfiguration.getCurrent().getPort());
    }

    public static void waitForAvailablePort(int port) throws InterruptedException, UnknownHostException {
        InetAddress serverAddress = InetAddress.getByName(TestConfiguration.getCurrent().getHostName());
        long giveUp = System.currentTimeMillis() + NetworkServerTestSetup.getWaitTime();
        BaseTestCase.println("probing port for availability: " + String.valueOf(serverAddress) + ":" + port);
        while (true) {
            try {
                NetworkServerTestSetup.probeServerPort(port, serverAddress);
            }
            catch (IOException ioe) {
                if (System.currentTimeMillis() < giveUp) {
                    Thread.sleep(100L);
                    continue;
                }
                BaseTestCase.fail(NetworkServerTestSetup.getTimeoutErrorMsg("server port to become available", port), ioe);
                continue;
            }
            break;
        }
    }

    private static void probeServerPort(int port, InetAddress addr) throws IOException {
        new ServerSocket(port, 0, addr).close();
    }

    private void startWithAPI() throws Exception {
        BaseTestCase.println("Starting network server with NetworkServerControl api:");
        File logs = new File("logs");
        logs.mkdir();
        File console = new File(logs, "serverConsoleOutput.log");
        Object fos = null;
        try {
            this.serverOutput = new FileOutputStream(console.getPath(), true);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.networkServerController.start(new PrintWriter(this.serverOutput));
    }

    private void startWithCommand() throws Exception {
        new Thread(new Runnable(this){

            @Override
            public void run() {
                String[] args = NetworkServerTestSetup.getDefaultStartupArgs(false);
                BaseTestCase.println("Starting network server with this command: " + String.valueOf(Arrays.asList(args)));
                NetworkServerControl.main((String[])args);
            }
        }, "NetworkServerTestSetup command").start();
    }

    private SpawnedProcess startSeparateProcess() throws Exception {
        BaseTestCase.println("Starting network server as a separate process:");
        ArrayList<Object> al = new ArrayList<Object>();
        boolean skipHostName = false;
        int count = this.systemProperties.length;
        for (int i = 0; i < count; ++i) {
            al.add("-D" + this.systemProperties[i]);
        }
        String serverName = NetworkServerControl.class.getName();
        if (this.useModules) {
            al.add("-m");
            al.add("org.apache.derby.server/" + serverName);
        } else {
            al.add(serverName);
        }
        count = this.startupArgs.length;
        for (int i = 0; i < count; ++i) {
            if (!HOST_OPTION.equals(this.startupArgs[i])) continue;
            skipHostName = true;
        }
        al.addAll(Arrays.asList(NetworkServerTestSetup.getDefaultStartupArgs(skipHostName)));
        al.addAll(Arrays.asList(this.startupArgs));
        String[] command = new String[al.size()];
        al.toArray(command);
        Process serverProcess = BaseTestCase.execJavaCmd(null, this.moduleOrClassPath, command, null, true, this.useModules);
        return new SpawnedProcess(serverProcess, "SpawnedNetworkServer");
    }

    public SpawnedProcess getServerProcess() {
        return this.spawnedServer;
    }

    protected void tearDown() throws Exception {
        if (this.networkServerController != null) {
            Throwable failedShutdown;
            block13: {
                boolean running = false;
                try {
                    this.networkServerController.ping();
                    running = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                failedShutdown = null;
                if (running) {
                    try {
                        this.networkServerController.shutdown();
                    }
                    catch (Throwable t) {
                        String errorMessage = t.getMessage();
                        if (errorMessage != null && errorMessage.contains("DRDA_InvalidReplyHead")) break block13;
                        failedShutdown = t;
                    }
                }
            }
            if (this.serverOutput != null) {
                this.serverOutput.close();
            }
            this.networkServerController = null;
            this.serverOutput = null;
            if (this.spawnedServer != null) {
                if (this.suppressServerDiagnostics) {
                    this.spawnedServer.suppressOutputOnComplete();
                }
                this.spawnedServer.complete(NetworkServerTestSetup.getWaitTime());
                this.spawnedServer = null;
            }
            if (failedShutdown != null) {
                if (failedShutdown instanceof Exception) {
                    if (!(failedShutdown instanceof SQLException)) {
                        throw (Exception)failedShutdown;
                    }
                } else {
                    throw (Error)failedShutdown;
                }
            }
        }
    }

    public static String[] getDefaultStartupArgs(boolean skipHostName) {
        TestConfiguration config = TestConfiguration.getCurrent();
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("start");
        if (!skipHostName) {
            argsList.add(HOST_OPTION);
            argsList.add(config.getHostName());
        }
        argsList.add("-p");
        argsList.add(Integer.toString(config.getPort()));
        if (config.getSsl() != null) {
            argsList.add("-ssl");
            argsList.add(config.getSsl());
        }
        String[] retval = new String[argsList.size()];
        argsList.toArray(retval);
        return retval;
    }

    public static NetworkServerControl getNetworkServerControl() throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        InetAddress host = InetAddress.getByName(config.getHostName());
        int port = config.getPort();
        String user = config.getUserName();
        String password = config.getUserPassword();
        if (config.getSsl() == null) {
            return new NetworkServerControl(host, port, user, password);
        }
        String oldValue = BaseTestCase.getSystemProperty("derby.drda.sslMode");
        BaseTestCase.setSystemProperty("derby.drda.sslMode", config.getSsl());
        NetworkServerControl control = new NetworkServerControl(host, port, user, password);
        if (oldValue == null) {
            BaseTestCase.removeSystemProperty("derby.drda.sslMode");
        } else {
            BaseTestCase.setSystemProperty("derby.drda.sslMode", oldValue);
        }
        return control;
    }

    public static NetworkServerControl getNetworkServerControl(int port) throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        InetAddress host = InetAddress.getByName(config.getHostName());
        String user = config.getUserName();
        String password = config.getUserPassword();
        return new NetworkServerControl(host, port, user, password);
    }

    public static NetworkServerControl getNetworkServerControlDefault() throws Exception {
        TestConfiguration config = TestConfiguration.getCurrent();
        String user = config.getUserName();
        String password = config.getUserPassword();
        return new NetworkServerControl(user, password);
    }

    public static void waitForServerStart(NetworkServerControl networkServerController) throws InterruptedException {
        if (!NetworkServerTestSetup.pingForServerStart(networkServerController)) {
            NetworkServerTestSetup.fail((String)NetworkServerTestSetup.getTimeoutErrorMsg("network server to start"));
        }
    }

    public static void setWaitTime(long newWaitTime) {
        waitTime = newWaitTime;
    }

    public static void setDefaultWaitTime() {
        waitTime = WAIT_TIME;
    }

    public static boolean pingForServerUp(NetworkServerControl networkServerController, Process serverProcess, boolean expectServerUp) throws InterruptedException {
        boolean alreadyGotReplyTooShort = false;
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                networkServerController.ping();
                long elapsed = System.currentTimeMillis() - startTime;
                if (expectServerUp) {
                    if (elapsed > 60000L) {
                        BaseTestCase.alarm("Very slow server startup: " + elapsed + " ms");
                    }
                    return true;
                }
                if (elapsed > waitTime) {
                    return true;
                }
            }
            catch (Throwable e) {
                if (!NetworkServerTestSetup.vetPing(e)) {
                    if (!alreadyGotReplyTooShort && e.getMessage().startsWith("DRDA_InvalidReplyTooShort.S:")) {
                        alreadyGotReplyTooShort = true;
                        Thread.sleep(100L);
                        continue;
                    }
                    e.printStackTrace(System.out);
                    return false;
                }
                if (expectServerUp) {
                    if (System.currentTimeMillis() - startTime > waitTime) {
                        return false;
                    }
                }
                return false;
            }
            if (serverProcess != null) {
                try {
                    int exitVal = serverProcess.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException exitVal) {
                }
                catch (Throwable t) {
                    t.printStackTrace(System.out);
                    return false;
                }
            }
            Thread.sleep(100L);
        }
    }

    private static boolean vetPing(Throwable t) {
        if (!t.getClass().getName().equals("java.lang.Exception")) {
            return false;
        }
        return t.getMessage().startsWith("DRDA_NoIO.S:");
    }

    private static boolean isDRDAerror(Throwable t) {
        if (!t.getClass().getName().equals("java.lang.Exception")) {
            return false;
        }
        return t.getMessage().startsWith("DRDA");
    }

    public static boolean pingForServerStart(NetworkServerControl control) throws InterruptedException {
        return NetworkServerTestSetup.pingForServerUp(control, null, true);
    }

    public static long getWaitTime() {
        long waitTime = 240000L;
        String waitString = BaseTestCase.getSystemProperty("derby.tests.networkServerStartTimeout");
        if (waitString != null && waitString.length() != 0) {
            try {
                waitTime = Long.parseLong(waitString) * 1000L;
            }
            catch (Exception e) {
                BaseTestCase.fail("trouble setting WAIT_TIME from passed in property derby.tests.networkServerStartTimeout", e);
            }
        }
        return waitTime;
    }

    private static String getTimeoutErrorMsg(String failedAction, int port) {
        TestConfiguration conf = TestConfiguration.getCurrent();
        String host = conf.getHostName();
        return "Timed out waiting for " + failedAction + " (" + host + ":" + port + ")";
    }

    private static String getTimeoutErrorMsg(String failedAction) {
        TestConfiguration conf = TestConfiguration.getCurrent();
        int port = conf.getPort();
        return NetworkServerTestSetup.getTimeoutErrorMsg(failedAction, port);
    }

    static {
        waitTime = WAIT_TIME = NetworkServerTestSetup.getWaitTime();
    }
}

