/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class EncryptionAESTest
extends BaseJDBCTestCase {
    private static final String TABLE = "encryptionkeytestdata";
    private static final int[] DATA = new int[]{9, 4, 2, 34, 6543, 3, 123, 434, 5436, -123, 0, 123};

    public EncryptionAESTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Encryption AES suite");
        suite.addTest(TestConfiguration.embeddedSuite(EncryptionAESTest.class));
        return new SupportFilesSetup((Test)suite);
    }

    public void testFeedbackModes() throws SQLException {
        String[] feedbackModes = new String[]{"CBC", "ECB", "OFB", "CFB", "ABC"};
        for (int i = 0; i < feedbackModes.length; ++i) {
            this.runTestFeedbackModes(feedbackModes[i]);
        }
    }

    protected void runTestFeedbackModes(String feedbackMode) throws SQLException {
        String dbName = "encryptedDB_Feedback" + feedbackMode;
        String encryptionAlgorithm = "AES/" + feedbackMode + "/NoPadding";
        String[] bootPassword = new String[]{"bootPassword=Thursday"};
        if (feedbackMode == "ABC") {
            this.assertNoDBCreated("XBCXI", dbName, encryptionAlgorithm, bootPassword);
            return;
        }
        Connection con = this.createAndPopulateDB(dbName, encryptionAlgorithm, bootPassword);
        this.validateDBContents(con);
        con.close();
        this.shutdown(dbName);
        con = this.getConnection(dbName, encryptionAlgorithm, bootPassword);
        this.validateDBContents(con);
        con.close();
        this.shutdown(dbName);
    }

    public void testUnsupportedPadding() throws SQLException {
        this.assertNoDBCreated("XBCXB", "badPadDB", "AES/ECB/PKCS5Padding", new String[]{"bootPassword=Thursday"});
    }

    public void testEncryptionKeyLengths() throws SQLException {
        String[] encryptionKeyLengths = new String[]{"128", "192", "256"};
        for (int i = 0; i < encryptionKeyLengths.length; ++i) {
            this.runTestEncryptionKeyLengths(encryptionKeyLengths[i]);
        }
        this.assertNoDBCreated("XJ001", "badKeyLengthDB", "AES/ECB/NoPadding", new String[]{"encryptionKeyLength=512", "bootPassword=Thursday"});
    }

    protected void runTestEncryptionKeyLengths(String encryptionKeyLength) throws SQLException {
        String dbName = "encrKeyLength" + encryptionKeyLength + "DB";
        String encryptionAlgorithm = "AES/CBC/NoPadding";
        String[] attributes = new String[]{"encryptionKeyLength=" + encryptionKeyLength, "bootPassword=Thursday"};
        Connection con = this.createAndPopulateDB(dbName, encryptionAlgorithm, attributes);
        if (con == null) {
            if (TestConfiguration.getCurrent().doTrace()) {
                System.out.println("no unrestricted policy jars; cannot test AES encryption with encryptionKeyLengths 192 nor 256");
            }
            return;
        }
        this.validateDBContents(con);
        con.close();
        this.shutdown(dbName);
        con = this.getConnection(dbName, encryptionAlgorithm, attributes);
        this.validateDBContents(con);
        con.close();
        con = this.getDriverManagerConnection(dbName, encryptionAlgorithm, attributes);
        this.validateDBContents(con);
        con.close();
        this.shutdown(dbName);
        String[] keyLengths = new String[]{"128", "192", "256", "512"};
        for (int i = 0; i < keyLengths.length; ++i) {
            if (encryptionKeyLength.equals(keyLengths[i])) continue;
            attributes = new String[]{"encryptionKeyLength=" + keyLengths[i], "bootPassword=Thursday"};
            this.runMismatchKeyLength(dbName, encryptionAlgorithm, encryptionKeyLength, attributes);
        }
        attributes = new String[]{"encryptionKeyLength=" + encryptionKeyLength, "bootPassword=Thursday", "newBootPassword=Saturday"};
        con = this.getDriverManagerConnection(dbName, encryptionAlgorithm, attributes);
        this.validateDBContents(con);
        con.close();
        this.shutdown(dbName);
        attributes = new String[]{"encryptionKeyLength=" + encryptionKeyLength, "bootPassword=Saturday"};
        con = this.getDriverManagerConnection(dbName, encryptionAlgorithm, attributes);
        this.validateDBContents(con);
        con.close();
        this.shutdown(dbName);
    }

    public void runMismatchKeyLength(String dbName, String encryptionAlgorithm, String encryptionKeyLength, String[] attributes) throws SQLException {
        Connection con = null;
        try {
            con = this.getConnection(dbName, encryptionAlgorithm, attributes);
            this.validateDBContents(con);
            con.close();
            this.shutdown(dbName);
        }
        catch (SQLException e) {
            e.printStackTrace();
            con.close();
            this.shutdown(dbName);
            EncryptionAESTest.assertSQLState("XBM06", e);
        }
    }

    private String obtainDbName(String dbName) {
        File tmp = new File(dbName);
        return PrivilegedFileOpsForTests.getAbsolutePath(new File("extinout", tmp.getPath()));
    }

    protected void assertNoDBCreated(String expectedSQLState, String dbName, String algorithm, String[] otherAttributes) throws SQLException {
        try {
            this.getConnection(dbName, algorithm, otherAttributes);
            EncryptionAESTest.fail((String)"expected error message re unsupported functionality");
        }
        catch (SQLException e) {
            EncryptionAESTest.assertSQLState(expectedSQLState, e);
        }
    }

    protected Connection createAndPopulateDB(String dbName, String algorithm, String[] otherAttributes) throws SQLException {
        try {
            Connection con = this.getConnection(dbName, algorithm, otherAttributes);
            SQLWarning warning = con.getWarnings();
            if (warning != null && "01J01".equals(warning.getSQLState())) {
                EncryptionAESTest.fail((String)("Refusing to continue, database already exists <" + warning.getMessage() + ">"));
            }
            Statement stmt = con.createStatement();
            stmt.executeUpdate("CREATE TABLE encryptionkeytestdata (id int NOT NULL, val int NOT NULL, PRIMARY KEY(id))");
            stmt.close();
            PreparedStatement ps = con.prepareStatement("INSERT INTO encryptionkeytestdata (id, val) VALUES (?,?)");
            for (int i = 0; i < DATA.length; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, DATA[i]);
                ps.executeUpdate();
            }
            ps.close();
            return con;
        }
        catch (SQLException e) {
            EncryptionAESTest.assertSQLState("XJ001", e);
            return null;
        }
    }

    private Connection getConnection(String dbName, String algorithm, String[] otherAttributes) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(this.obtainDbName(dbName));
        StringBuffer str = new StringBuffer(75);
        JDBCDataSource.setBeanProperty(ds, "CreateDatabase", "create");
        str.append("dataEncryption=true;");
        str.append("encryptionAlgorithm=");
        str.append(algorithm);
        str.append(";");
        for (int i = 0; i < otherAttributes.length; ++i) {
            str.append(otherAttributes[i]);
            str.append(";");
        }
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", str.toString());
        return ds.getConnection();
    }

    private Connection getDriverManagerConnection(String dbName, String algorithm, String[] otherAttributes) throws SQLException {
        Object url = TestConfiguration.getCurrent().getJDBCUrl(this.obtainDbName(dbName));
        url = (String)url + ";create=true;dataEncryption=true;encryptionAlgorithm=" + algorithm + ";";
        for (int i = 0; i < otherAttributes.length; ++i) {
            url = (String)url + otherAttributes[i] + ";";
        }
        String driver = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
        try {
            Class<?> clazz = Class.forName(driver);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            EncryptionAESTest.fail((String)("\nUnable to load the JDBC driver " + driver));
        }
        catch (InstantiationException ie) {
            EncryptionAESTest.fail((String)("\nUnable to instantiate the JDBC driver " + driver));
        }
        catch (IllegalAccessException iae) {
            EncryptionAESTest.fail((String)("\nNot allowed to access the JDBC driver " + driver));
        }
        catch (NoSuchMethodException iae) {
            EncryptionAESTest.fail((String)("\nNo such constructor for the JDBC driver " + driver));
        }
        catch (InvocationTargetException iae) {
            EncryptionAESTest.fail((String)("\nCannot invoke the constructor for the the JDBC driver " + driver));
        }
        Connection conn = DriverManager.getConnection((String)url);
        return conn;
    }

    protected void shutdown(String databaseName) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource(this.obtainDbName(databaseName));
        JDBCDataSource.shutdownDatabase(ds);
    }

    protected void validateDBContents(Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT id, val FROM encryptionkeytestdata ORDER BY id");
        JDBC.assertFullResultSet(rs, new String[][]{{"0", "9"}, {"1", "4"}, {"2", "2"}, {"3", "34"}, {"4", "6543"}, {"5", "3"}, {"6", "123"}, {"7", "434"}, {"8", "5436"}, {"9", "-123"}, {"10", "0"}, {"11", "123"}});
        rs.close();
        stmt.close();
    }
}

