/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HalfCreatedDatabaseTest
extends BaseJDBCTestCase {
    private static final String DB_NAME = "hcdt_db";
    private static final String DB_DIRECTORY = "system" + File.separator + "hcdt_db";
    private static final String SERVICE_PROPERTIES_FILE_NAME = DB_DIRECTORY + File.separator + "service.properties";
    private static final String RENAMED_FILE_NAME = DB_DIRECTORY + File.separator + "renamed.properties";

    public HalfCreatedDatabaseTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("HalfCreatedDatabaseTest");
        suite.addTest(HalfCreatedDatabaseTest.decorateTest());
        return suite;
    }

    private static Test decorateTest() {
        BaseTestSuite test = new BaseTestSuite(HalfCreatedDatabaseTest.class);
        test = TestConfiguration.singleUseDatabaseDecorator((Test)test, DB_NAME);
        return test;
    }

    public void test_4589() throws Exception {
        this.getConnection();
        this.getTestConfiguration().shutdownDatabase();
        File serviceProperties = new File(SERVICE_PROPERTIES_FILE_NAME);
        File renamedProperties = new File(RENAMED_FILE_NAME);
        serviceProperties.renameTo(renamedProperties);
        try {
            this.getConnection();
            HalfCreatedDatabaseTest.fail((String)"Should not be able to get a connection.");
        }
        catch (SQLException se) {
            boolean sawCorrectError = false;
            while (se != null) {
                String sqlstate = se.getSQLState();
                if ("XBM0A".equals(sqlstate)) {
                    sawCorrectError = true;
                    break;
                }
                se = se.getNextException();
            }
            HalfCreatedDatabaseTest.assertTrue((boolean)sawCorrectError);
        }
        renamedProperties.renameTo(serviceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_5526() throws SQLException {
        String mydatadirStr = BaseTestCase.getSystemProperty("derby.system.home") + File.separator + "mydatadir";
        File mydatadir = new File(mydatadirStr);
        HalfCreatedDatabaseTest.assertTrue((boolean)mydatadir.mkdir());
        DataSource ds = JDBCDataSource.getDataSource(mydatadirStr);
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        try {
            ds.getConnection();
            HalfCreatedDatabaseTest.fail((String)("Should not be able to create database on existing directory " + mydatadirStr));
        }
        catch (SQLException se) {
            HalfCreatedDatabaseTest.assertSQLState("XJ041", se);
            se = se.getNextException();
            HalfCreatedDatabaseTest.assertSQLState("XBM0J", se);
        }
        finally {
            BaseTestCase.removeDirectory(mydatadir);
        }
    }
}

