/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.reference.Attribute;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.AttributeHolder;

public class URLCheck {
    private Vector<AttributeHolder> attributes;
    private static Vector<String> booleanAttributes;
    private LocalizedResource langUtil = LocalizedResource.getInstance();
    private Vector<String> validProps;
    private static Vector<String> validDerbyProps;

    public URLCheck(String anURL) {
        try {
            Properties props = this.getAttributes(anURL, new Properties());
            this.check();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            URLCheck uRLCheck = new URLCheck(args[0]);
        }
    }

    public void check() {
        Enumeration<AttributeHolder> e = this.attributes.elements();
        while (e.hasMoreElements()) {
            AttributeHolder anAttribute = e.nextElement();
            this.checkForDuplicate(anAttribute);
            anAttribute.check(this.validProps);
        }
    }

    public void checkForDuplicate(AttributeHolder anAttribute) {
        Enumeration<AttributeHolder> e = this.attributes.elements();
        while (e.hasMoreElements()) {
            AttributeHolder aHolder = e.nextElement();
            if (anAttribute == aHolder || !anAttribute.getName().equals(aHolder.getName())) continue;
            anAttribute.addError(this.langUtil.getTextMessage("TL_dupAtt", new Object[0]));
        }
    }

    public Properties getAttributes(String url, Properties props) throws Exception {
        String protocol = "";
        if (url.startsWith("jdbc:derby:net:") || url.startsWith("jdbc:derby://")) {
            this.validProps = null;
        } else if (url.startsWith("jdbc:derby:")) {
            protocol = "jdbc:derby:";
            this.validProps = this.getValidDerbyProps();
        } else {
            this.validProps = null;
        }
        StringTokenizer st = new StringTokenizer(url.substring(protocol.length()), ";:\"");
        this.attributes = new Vector();
        while (st.hasMoreTokens()) {
            AttributeHolder anAttribute = new AttributeHolder();
            String anAtt = "";
            String aValue = "";
            String aToken = st.nextToken();
            int eqPos = aToken.indexOf(61);
            if (eqPos == -1) continue;
            anAtt = aToken.substring(0, eqPos).trim();
            aValue = aToken.substring(eqPos + 1).trim();
            anAttribute.setName(anAtt);
            anAttribute.setValue(aValue);
            anAttribute.setToken(aToken);
            this.attributes.addElement(anAttribute);
            props.put(anAtt, aToken);
        }
        return props;
    }

    public static Vector<String> getBooleanAttributes() {
        if (booleanAttributes == null) {
            booleanAttributes = new Vector();
            booleanAttributes.addElement("dataEncryption");
            booleanAttributes.addElement("create");
            booleanAttributes.addElement("shutdown");
            booleanAttributes.addElement("upgrade");
        }
        return booleanAttributes;
    }

    private Vector<String> getValidDerbyProps() {
        if (validDerbyProps == null) {
            try {
                Vector<String> props = new Vector<String>();
                Class<Attribute> att = Attribute.class;
                Field[] fields = att.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field aField = fields[i];
                    props.addElement((String)aField.get(att));
                }
                validDerbyProps = props;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return validDerbyProps;
    }
}

