/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.security.auth.Subject;
import junit.framework.Test;
import org.apache.derby.authentication.SystemPrincipal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.security.DatabasePermission;
import org.apache.derby.security.SystemPermission;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class SystemPrivilegesPermissionTest
extends BaseTestCase {
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/unitTests/junit/SystemPrivilegesPermissionTest.policy";
    private static final String POLICY_FILE_NAME1 = "org/apache/derbyTesting/unitTests/junit/SystemPrivilegesPermissionTest1.policy";
    private static final String[] dirPaths;
    private static final String[] relDirPaths;
    private static final String[] relDirPathAliases;
    private static final String[] absDirPaths;
    private static final String[] absDirPathAliases;
    private static final boolean[][] dirPathImpls;
    private static final String[] VALID_SYSPERM_NAMES;
    private static final String[] VALID_SYSPERM_ACTIONS;

    public SystemPrivilegesPermissionTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("SystemPrivilegesPermissionTest");
        suite.addTest((Test)new SystemPrivilegesPermissionTest("testSystemPrincipal"));
        suite.addTest((Test)new SystemPrivilegesPermissionTest("testSystemPermission"));
        suite.addTest((Test)new SystemPrivilegesPermissionTest("testSystemPermissionCollections"));
        suite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("testDatabasePermission"), POLICY_FILE_NAME1));
        if (SecurityManagerSetup.JVM_HAS_SUBJECT_AUTHORIZATION) {
            suite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("policyTestSystemPermissionGrants"), POLICY_FILE_NAME));
            suite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("policyTestDatabasePermissionGrants"), POLICY_FILE_NAME));
        }
        if (SystemPrivilegesPermissionTest.isJava8()) {
            suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new SystemPrivilegesPermissionTest("testSerialization")));
        }
        return suite;
    }

    public void testSystemPrincipal() {
        SystemPrincipal p = new SystemPrincipal("superuser");
        SystemPrivilegesPermissionTest.assertEquals((String)"superuser", (String)p.getName());
        try {
            new SystemPrincipal(null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new SystemPrincipal("");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        SystemPrivilegesPermissionTest.assertTrue((boolean)Modifier.isFinal(SystemPrincipal.class.getModifiers()));
    }

    public void testSystemPermission() {
        int a;
        try {
            new SystemPermission(null, null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new SystemPermission("", null);
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SystemPermission("illegal_name", null);
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SystemPermission("server", null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SystemPrivilegesPermissionTest.assertEquals((String)"", (String)new SystemPermission("server", "").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"", (String)new SystemPermission("server", ",,").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"", (String)new SystemPermission("server", "illegal_action").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "control,").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "control,illegal_action").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "control,control").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control,monitor", (String)new SystemPermission("server", "control, monitor, control").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control,monitor", (String)new SystemPermission("server", "monitor, control, monitor").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "CoNtRoL").getActions());
        SystemPrivilegesPermissionTest.assertEquals((String)"control", (String)new SystemPermission("server", "CoNtRoL,control").getActions());
        String[] validNames = new String[]{"engine", "jmx", "server"};
        String[] validActions = new String[]{"control", "monitor", "shutdown"};
        Permission[] all = new Permission[validNames.length * validActions.length];
        int c = 0;
        for (int tn = 0; tn < validNames.length; ++tn) {
            for (a = 0; a < validActions.length; ++a) {
                SystemPermission p = new SystemPermission(validNames[tn], validActions[a]);
                SystemPrivilegesPermissionTest.assertEquals((String)validNames[tn], (String)p.getName());
                SystemPrivilegesPermissionTest.assertEquals((String)validActions[a], (String)p.getActions());
                SystemPrivilegesPermissionTest.assertFalse((boolean)p.equals(null));
                SystemPrivilegesPermissionTest.assertFalse((boolean)p.equals(new Object()));
                this.assertEquivalentPermissions((Permission)p, (Permission)p);
                all[c++] = p;
            }
        }
        this.checkDistinctPermissions(all);
        for (int n = 0; n < validNames.length; ++n) {
            for (a = 0; a < validActions.length; ++a) {
                SystemPermission base = new SystemPermission(validNames[n], validActions[a]);
                for (int oa = 0; oa < validActions.length; ++oa) {
                    int s;
                    int f;
                    SystemPermission p = new SystemPermission(validNames[n], validActions[a] + "," + validActions[oa]);
                    if (oa == a) {
                        this.assertEquivalentPermissions((Permission)base, (Permission)p);
                        SystemPrivilegesPermissionTest.assertEquals((String)validActions[a], (String)p.getActions());
                        continue;
                    }
                    SystemPrivilegesPermissionTest.assertTrue((boolean)p.implies((Permission)base));
                    SystemPrivilegesPermissionTest.assertFalse((boolean)base.implies((Permission)p));
                    if (oa < a) {
                        f = oa;
                        s = a;
                    } else {
                        f = a;
                        s = oa;
                    }
                    SystemPrivilegesPermissionTest.assertEquals((String)(validActions[f] + "," + validActions[s]), (String)p.getActions());
                }
            }
        }
        SystemPrivilegesPermissionTest.assertTrue((boolean)Modifier.isFinal(SystemPermission.class.getModifiers()));
    }

    public void testSystemPermissionCollections() {
        Permissions allPerms = new Permissions();
        for (String name : VALID_SYSPERM_NAMES) {
            for (String action : VALID_SYSPERM_ACTIONS) {
                allPerms.add((Permission)new SystemPermission(name, action));
            }
        }
        SystemPrivilegesPermissionTest.assertEquals((int)VALID_SYSPERM_NAMES.length, (int)Collections.list(allPerms.elements()).size());
        for (String name : VALID_SYSPERM_NAMES) {
            for (String a1 : VALID_SYSPERM_ACTIONS) {
                SystemPrivilegesPermissionTest.assertTrue((boolean)allPerms.implies((Permission)new SystemPermission(name, a1)));
                for (String a2 : VALID_SYSPERM_ACTIONS) {
                    SystemPrivilegesPermissionTest.assertTrue((boolean)allPerms.implies((Permission)new SystemPermission(name, a1 + ',' + a2)));
                }
            }
        }
        Permissions onePerm = new Permissions();
        onePerm.add((Permission)new SystemPermission("server", "shutdown"));
        SystemPrivilegesPermissionTest.assertTrue((boolean)onePerm.implies((Permission)new SystemPermission("server", "shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)onePerm.implies((Permission)new SystemPermission("engine", "shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)onePerm.implies((Permission)new SystemPermission("server", "shutdown,monitor")));
        Permissions somePerms = new Permissions();
        somePerms.add((Permission)new SystemPermission("server", "shutdown"));
        somePerms.add((Permission)new SystemPermission("jmx", "shutdown,monitor"));
        somePerms.add((Permission)new SystemPermission("engine", "shutdown,control"));
        somePerms.add((Permission)new SystemPermission("engine", "control,monitor"));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("server", "shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)somePerms.implies((Permission)new SystemPermission("server", "control")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)somePerms.implies((Permission)new SystemPermission("server", "monitor")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)somePerms.implies((Permission)new SystemPermission("server", "shutdown,monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("jmx", "shutdown")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("jmx", "monitor")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)somePerms.implies((Permission)new SystemPermission("jmx", "control")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("jmx", "shutdown,monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("jmx", "monitor,shutdown")));
        SystemPrivilegesPermissionTest.assertFalse((boolean)somePerms.implies((Permission)new SystemPermission("jmx", "monitor,shutdown,control")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("engine", "shutdown")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("engine", "control")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("engine", "monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("engine", "shutdown,monitor")));
        SystemPrivilegesPermissionTest.assertTrue((boolean)somePerms.implies((Permission)new SystemPermission("engine", "shutdown,monitor,control")));
        SystemPermission sp = new SystemPermission("engine", "monitor");
        PermissionCollection collection = sp.newPermissionCollection();
        try {
            collection.add(new AllPermission());
            SystemPrivilegesPermissionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        collection.setReadOnly();
        try {
            collection.add((Permission)sp);
            SystemPrivilegesPermissionTest.fail();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SystemPrivilegesPermissionTest.assertFalse((boolean)collection.implies(new AllPermission()));
    }

    public void policyTestSystemPermissionGrants() {
        SystemPermission shutdown2 = new SystemPermission("server", "shutdown");
        SystemPrincipal authorizedUser = new SystemPrincipal("authorizedSystemUser");
        this.execute(authorizedUser, new ShutdownAction((Permission)shutdown2), true);
        SystemPrincipal unAuthorizedUser = new SystemPrincipal("unAuthorizedSystemUser");
        this.execute(unAuthorizedUser, new ShutdownAction((Permission)shutdown2), false);
    }

    public void testDatabasePermission() throws IOException {
        try {
            new DatabasePermission(null, "create");
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new DatabasePermission("", "create");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("no_url", "create");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("unknown:test", "create");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal_action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal,action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal,create,action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "illegal;action");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", ",");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", " ");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DatabasePermission("directory:dir", "create,");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DatabasePermission[] relDirPathPerms = new DatabasePermission[relDirPaths.length];
        for (int i = 0; i < relDirPaths.length; ++i) {
            relDirPathPerms[i] = new DatabasePermission(relDirPaths[i], "create");
        }
        this.checkNameAndActions(relDirPathPerms, relDirPaths);
        this.checkHashCodeAndEquals((Permission[])relDirPathPerms, (Permission[])relDirPathPerms);
        this.checkImplies((Permission[])relDirPathPerms, (Permission[])relDirPathPerms, dirPathImpls);
        DatabasePermission[] relDirPathAliasPerms = new DatabasePermission[relDirPathAliases.length];
        for (int i = 0; i < relDirPathAliases.length; ++i) {
            relDirPathAliasPerms[i] = new DatabasePermission(relDirPathAliases[i], "create");
        }
        this.checkNameAndActions(relDirPathAliasPerms, relDirPathAliases);
        this.checkHashCodeAndEquals((Permission[])relDirPathPerms, (Permission[])relDirPathAliasPerms);
        this.checkImplies((Permission[])relDirPathPerms, (Permission[])relDirPathAliasPerms, dirPathImpls);
        this.checkImplies((Permission[])relDirPathAliasPerms, (Permission[])relDirPathPerms, dirPathImpls);
        DatabasePermission[] absDirPathPerms = new DatabasePermission[absDirPaths.length];
        for (int i = 0; i < absDirPaths.length; ++i) {
            absDirPathPerms[i] = new DatabasePermission(absDirPaths[i], "create");
        }
        this.checkNameAndActions(absDirPathPerms, absDirPaths);
        this.checkHashCodeAndEquals((Permission[])absDirPathPerms, (Permission[])absDirPathPerms);
        this.checkImplies((Permission[])absDirPathPerms, (Permission[])absDirPathPerms, dirPathImpls);
        DatabasePermission[] absDirPathAliasPerms = new DatabasePermission[absDirPathAliases.length];
        for (int i = 0; i < absDirPathAliases.length; ++i) {
            absDirPathAliasPerms[i] = new DatabasePermission(absDirPathAliases[i], "create");
        }
        this.checkNameAndActions(absDirPathAliasPerms, absDirPathAliases);
        this.checkHashCodeAndEquals((Permission[])absDirPathPerms, (Permission[])absDirPathAliasPerms);
        this.checkImplies((Permission[])absDirPathPerms, (Permission[])absDirPathAliasPerms, dirPathImpls);
        this.checkImplies((Permission[])absDirPathAliasPerms, (Permission[])absDirPathPerms, dirPathImpls);
        String inclPermissionUrl = "directory:<<ALL FILES>>";
        DatabasePermission[] inclPerms = new DatabasePermission[]{new DatabasePermission("directory:<<ALL FILES>>", "create")};
        this.checkNameAndActions(inclPerms, new String[]{"directory:<<ALL FILES>>"});
        DatabasePermission[] inclPerms1 = new DatabasePermission[]{new DatabasePermission("directory:<<ALL FILES>>", "create")};
        this.checkHashCodeAndEquals((Permission[])inclPerms, (Permission[])inclPerms1);
        this.checkImplies((Permission[])inclPerms, (Permission[])inclPerms1, new boolean[][]{{true}});
        boolean[][] allTrue = new boolean[1][dirPaths.length];
        for (int j = 0; j < dirPaths.length; ++j) {
            allTrue[0][j] = true;
        }
        boolean[][] allFalse = new boolean[dirPaths.length][1];
        for (int i = 0; i < dirPaths.length; ++i) {
            allFalse[i][0] = false;
        }
        this.checkImplies((Permission[])inclPerms, (Permission[])relDirPathPerms, allTrue);
        this.checkImplies((Permission[])relDirPathPerms, (Permission[])inclPerms, allFalse);
        this.checkImplies((Permission[])inclPerms, (Permission[])relDirPathAliasPerms, allTrue);
        this.checkImplies((Permission[])relDirPathAliasPerms, (Permission[])inclPerms, allFalse);
        this.checkImplies((Permission[])inclPerms, (Permission[])absDirPathPerms, allTrue);
        this.checkImplies((Permission[])absDirPathPerms, (Permission[])inclPerms, allFalse);
        this.checkImplies((Permission[])inclPerms, (Permission[])absDirPathAliasPerms, allTrue);
        this.checkImplies((Permission[])absDirPathAliasPerms, (Permission[])inclPerms, allFalse);
        DatabasePermission perm = new DatabasePermission("directory:dir", "create, create");
        SystemPrivilegesPermissionTest.assertEquals((String)"create", (String)perm.getActions());
        perm = new DatabasePermission("directory:dir", "  CrEaTe  ");
        SystemPrivilegesPermissionTest.assertEquals((String)"create", (String)perm.getActions());
        SystemPrivilegesPermissionTest.assertTrue((boolean)Modifier.isFinal(DatabasePermission.class.getModifiers()));
    }

    public void policyTestDatabasePermissionGrants() throws IOException {
        DatabasePermission[] relDirPathPerms = new DatabasePermission[relDirPaths.length];
        for (int i = 0; i < relDirPaths.length; ++i) {
            relDirPathPerms[i] = new DatabasePermission(relDirPaths[i], "create");
        }
        int[] singleLocPaths = new int[]{2, 3, 6, 7};
        SystemPrincipal authorizedUser = new SystemPrincipal("authorizedSystemUser");
        SystemPrincipal unAuthorizedUser = new SystemPrincipal("unAuthorizedSystemUser");
        SystemPrincipal superUser = new SystemPrincipal("superUser");
        for (int i = 0; i < singleLocPaths.length; ++i) {
            int j = singleLocPaths[i];
            this.execute(unAuthorizedUser, new CreateDatabaseAction((Permission)relDirPathPerms[j]), false);
            this.execute(authorizedUser, new CreateDatabaseAction((Permission)relDirPathPerms[j]), j != 6);
            this.execute(superUser, new CreateDatabaseAction((Permission)relDirPathPerms[j]), true);
        }
        SystemPrincipal anyUser = new SystemPrincipal("anyUser");
        DatabasePermission dbPerm = new DatabasePermission("directory:dir", "create");
        this.execute(anyUser, new CreateDatabaseAction((Permission)dbPerm), true);
    }

    public void testSerialization() throws IOException {
        this.testDatabasePermissionSerialization();
        this.testSystemPermissionSerialization();
        this.testSystemPrincipalSerialization();
    }

    private void testDatabasePermissionSerialization() throws IOException {
        DatabasePermission perm = new DatabasePermission("directory:dir", "create");
        SystemPrivilegesPermissionTest.assertEquals((Object)perm, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(perm, null));
        for (String url : relDirPaths) {
            perm = new DatabasePermission(url, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)perm, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(perm, null));
        }
        for (String url : relDirPathAliases) {
            perm = new DatabasePermission(url, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)perm, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(perm, null));
        }
        for (String url : absDirPaths) {
            perm = new DatabasePermission(url, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)perm, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(perm, null));
        }
        for (String url : absDirPathAliases) {
            perm = new DatabasePermission(url, "create");
            SystemPrivilegesPermissionTest.assertEquals((Object)perm, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(perm, null));
        }
        for (String actions : Arrays.asList("create", "CrEaTe", " create ,  create")) {
            perm = SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", actions), null);
            SystemPrivilegesPermissionTest.assertEquals((String)"create", (String)perm.getActions());
        }
        perm = SystemPrivilegesPermissionTest.createDBPermNoCheck(null, "create");
        SystemPrivilegesPermissionTest.serializeDeserialize(perm, NullPointerException.class);
        perm = SystemPrivilegesPermissionTest.createDBPermNoCheck("", "create");
        SystemPrivilegesPermissionTest.serializeDeserialize(perm, IllegalArgumentException.class);
        perm = SystemPrivilegesPermissionTest.createDBPermNoCheck("unknown:test", "create");
        SystemPrivilegesPermissionTest.serializeDeserialize(perm, IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", null), NullPointerException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", ""), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", " "), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", ","), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", "create,"), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", "invalid"), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createDBPermNoCheck("directory:dir", "create,invalid"), IllegalArgumentException.class);
    }

    private void testSystemPermissionSerialization() throws IOException {
        for (String name : VALID_SYSPERM_NAMES) {
            for (String action : VALID_SYSPERM_ACTIONS) {
                SystemPermission pl = new SystemPermission(name, action.toLowerCase(Locale.US));
                SystemPermission pu = new SystemPermission(name, action.toUpperCase(Locale.US));
                SystemPrivilegesPermissionTest.assertEquals((Object)pl, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(pl, null));
                SystemPrivilegesPermissionTest.assertEquals((Object)pu, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(pu, null));
            }
        }
        SystemPermission sp = new SystemPermission("server", "control,monitor,shutdown");
        SystemPrivilegesPermissionTest.assertEquals((Object)sp, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(sp, null));
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck("server,jmx", "control"), IllegalArgumentException.class);
        sp = SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(VALID_SYSPERM_NAMES[0], "control,invalid,control,,shutdown"), null);
        SystemPrivilegesPermissionTest.assertEquals((String)"control,shutdown", (String)sp.getActions());
        sp = new SystemPermission(VALID_SYSPERM_NAMES[0], "");
        SystemPrivilegesPermissionTest.assertEquals((Object)sp, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(sp, null));
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(VALID_SYSPERM_NAMES[0].toUpperCase(Locale.US), VALID_SYSPERM_ACTIONS[0]), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck("", VALID_SYSPERM_ACTIONS[0]), IllegalArgumentException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(null, VALID_SYSPERM_ACTIONS[0]), NullPointerException.class);
        SystemPrivilegesPermissionTest.serializeDeserialize(SystemPrivilegesPermissionTest.createSyspermNoCheck(VALID_SYSPERM_NAMES[0], null), NullPointerException.class);
        PermissionCollection collection = sp.newPermissionCollection();
        PermissionCollection readCollection = SystemPrivilegesPermissionTest.serializeDeserialize(collection, null);
        SystemPrivilegesPermissionTest.assertFalse((boolean)readCollection.elements().hasMoreElements());
        sp = new SystemPermission(VALID_SYSPERM_NAMES[0], VALID_SYSPERM_ACTIONS[0]);
        collection = sp.newPermissionCollection();
        collection.add((Permission)sp);
        readCollection = SystemPrivilegesPermissionTest.serializeDeserialize(collection, null);
        SystemPrivilegesPermissionTest.assertEquals(Arrays.asList(sp), Collections.list(readCollection.elements()));
        collection.add((Permission)SystemPrivilegesPermissionTest.createSyspermNoCheck("invalid_name", "control"));
        SystemPrivilegesPermissionTest.serializeDeserialize(collection, IllegalArgumentException.class);
        collection = sp.newPermissionCollection();
        HashMap<String, AllPermission> permissions = new HashMap<String, AllPermission>();
        permissions.put("engine", new AllPermission());
        SystemPrivilegesPermissionTest.setField(collection.getClass(), "permissions", collection, permissions);
        SystemPrivilegesPermissionTest.serializeDeserialize(collection, ClassCastException.class);
    }

    private void testSystemPrincipalSerialization() throws IOException {
        SystemPrincipal p = new SystemPrincipal("superuser");
        SystemPrivilegesPermissionTest.assertEquals((Object)p, (Object)SystemPrivilegesPermissionTest.serializeDeserialize(p, null));
        SystemPrivilegesPermissionTest.setField(SystemPrincipal.class, "name", p, null);
        SystemPrivilegesPermissionTest.serializeDeserialize(p, NullPointerException.class);
        SystemPrivilegesPermissionTest.setField(SystemPrincipal.class, "name", p, "");
        SystemPrivilegesPermissionTest.serializeDeserialize(p, IllegalArgumentException.class);
    }

    private static DatabasePermission createDBPermNoCheck(String url, String actions) throws IOException {
        DatabasePermission perm = new DatabasePermission("directory:dir", "create");
        SystemPrivilegesPermissionTest.setField(Permission.class, "name", perm, url);
        SystemPrivilegesPermissionTest.setField(DatabasePermission.class, "actions", perm, actions);
        return perm;
    }

    private static SystemPermission createSyspermNoCheck(String name, String actions) {
        SystemPermission sysperm = new SystemPermission("server", "control");
        SystemPrivilegesPermissionTest.setField(Permission.class, "name", sysperm, name);
        SystemPrivilegesPermissionTest.setField(SystemPermission.class, "actions", sysperm, actions);
        return sysperm;
    }

    private static void setField(Class<?> klass, String name, Object object, Object value) {
        try {
            Field f = klass.getDeclaredField(name);
            f.setAccessible(true);
            f.set(object, value);
        }
        catch (NoSuchFieldException ex) {
            SystemPrivilegesPermissionTest.fail("Cannot find field " + name, ex);
        }
        catch (IllegalAccessException ex) {
            SystemPrivilegesPermissionTest.fail("Cannot access field " + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T serializeDeserialize(T object, Class<? extends Exception> expectedException) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));){
            Object deserialized = ois.readObject();
            SystemPrivilegesPermissionTest.assertNull((String)"should have failed", expectedException);
            SystemPrivilegesPermissionTest.assertEquals(object.getClass(), deserialized.getClass());
            Object object2 = deserialized;
            return (T)object2;
        }
    }

    private <T> void execute(SystemPrincipal principal, PrivilegedAction<T> action, boolean isGrantExpected) {
        block3: {
            RunAsPrivilegedUserAction<T> runAsPrivilegedUserAction = new RunAsPrivilegedUserAction<T>(principal, action);
            try {
                AccessController.doPrivileged(runAsPrivilegedUserAction);
                if (!isGrantExpected) {
                    SystemPrivilegesPermissionTest.fail((String)"expected AccessControlException");
                }
            }
            catch (AccessControlException ace) {
                if (!isGrantExpected) break block3;
                throw ace;
            }
        }
    }

    private void checkNameAndActions(DatabasePermission[] dbperm, String[] dbpath) throws IOException {
        for (int i = 0; i < dbperm.length; ++i) {
            DatabasePermission dbp = dbperm[i];
            SystemPrivilegesPermissionTest.assertEquals((String)("test: " + dbp + ".getName()"), (String)dbpath[i], (String)dbp.getName());
            SystemPrivilegesPermissionTest.assertEquals((String)("test: " + dbp + ".getActions()"), (String)"create", (String)dbp.getActions());
        }
    }

    private void checkHashCodeAndEquals(Permission[] dbp0, Permission[] dbp1) throws IOException {
        for (int i = 0; i < dbp0.length; ++i) {
            Permission p0 = dbp0[i];
            for (int j = 0; j < dbp0.length; ++j) {
                Permission p1 = dbp1[j];
                if (i == j) {
                    SystemPrivilegesPermissionTest.assertTrue((p0.hashCode() == p1.hashCode() ? 1 : 0) != 0);
                    SystemPrivilegesPermissionTest.assertTrue((boolean)p0.equals(p1));
                    continue;
                }
                SystemPrivilegesPermissionTest.assertTrue((p0.hashCode() != p1.hashCode() ? 1 : 0) != 0);
                SystemPrivilegesPermissionTest.assertTrue((!p0.equals(p1) ? 1 : 0) != 0);
            }
        }
    }

    private void checkImplies(Permission[] dbp0, Permission[] dbp1, boolean[][] impls) throws IOException {
        for (int i = 0; i < dbp0.length; ++i) {
            Permission p0 = dbp0[i];
            for (int j = 0; j < dbp1.length; ++j) {
                Permission p1 = dbp1[j];
                SystemPrivilegesPermissionTest.assertEquals((String)("test: " + p0 + ".implies" + p1), (boolean)impls[i][j], (boolean)p0.implies(p1));
            }
        }
    }

    private void checkDistinctPermissions(Permission[] set) {
        for (int i = 0; i < set.length; ++i) {
            Permission pi = set[i];
            for (int j = 0; j < set.length; ++j) {
                Permission pj = set[j];
                if (i == j) {
                    this.assertEquivalentPermissions(pi, pj);
                    continue;
                }
                SystemPrivilegesPermissionTest.assertFalse((boolean)pi.equals(pj));
                SystemPrivilegesPermissionTest.assertFalse((boolean)pj.equals(pi));
                SystemPrivilegesPermissionTest.assertFalse((boolean)pi.implies(pj));
                SystemPrivilegesPermissionTest.assertFalse((boolean)pj.implies(pi));
            }
        }
    }

    private void assertEquivalentPermissions(Permission p1, Permission p2) {
        SystemPrivilegesPermissionTest.assertTrue((boolean)p1.equals(p2));
        SystemPrivilegesPermissionTest.assertTrue((boolean)p2.equals(p1));
        SystemPrivilegesPermissionTest.assertEquals((int)p1.hashCode(), (int)p2.hashCode());
        SystemPrivilegesPermissionTest.assertTrue((boolean)p1.implies(p2));
        SystemPrivilegesPermissionTest.assertTrue((boolean)p2.implies(p1));
    }

    private static String getAuthorizationId(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId((String)name);
        }
        catch (StandardException se) {
            throw new IllegalArgumentException(se.getMessage());
        }
    }

    static {
        int i;
        dirPaths = new String[]{"-", "*", "level0", "level0a", "level0/-", "level0/*", "level0/level1", "level0/level1/level2"};
        relDirPaths = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.relDirPaths[i] = "directory:" + dirPaths[i];
        }
        relDirPathAliases = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.relDirPathAliases[i] = "directory:./" + dirPaths[i];
        }
        absDirPaths = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.absDirPaths[i] = "directory:/" + dirPaths[i];
        }
        absDirPathAliases = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.absDirPathAliases[i] = "directory:/dummy/../" + dirPaths[i];
        }
        dirPathImpls = new boolean[][]{{true, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, false}, {false, false, true, false, false, false, false, false}, {false, false, false, true, false, false, false, false}, {false, false, false, false, true, true, true, true}, {false, false, false, false, false, true, true, false}, {false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, true}};
        VALID_SYSPERM_NAMES = new String[]{"server", "engine", "jmx"};
        VALID_SYSPERM_ACTIONS = new String[]{"shutdown", "control", "monitor"};
    }

    public static class RunAsPrivilegedUserAction<T>
    implements PrivilegedAction<T> {
        private final SystemPrincipal principal;
        private final PrivilegedAction<? extends T> action;

        public RunAsPrivilegedUserAction(SystemPrincipal principal, PrivilegedAction<? extends T> action) {
            this.principal = principal;
            this.action = action;
        }

        @Override
        public T run() {
            boolean readOnly = true;
            HashSet<SystemPrincipal> principals = new HashSet<SystemPrincipal>();
            HashSet publicCredentials = new HashSet();
            HashSet privateCredentials = new HashSet();
            principals.add(this.principal);
            String normalized = SystemPrivilegesPermissionTest.getAuthorizationId(this.principal.getName());
            principals.add(new SystemPrincipal(normalized));
            Subject subject = new Subject(true, principals, publicCredentials, privateCredentials);
            return Subject.doAsPrivileged(subject, this.action, null);
        }
    }

    public class CreateDatabaseAction
    implements PrivilegedAction<Void> {
        protected final Permission permission;

        public CreateDatabaseAction(Permission permission) {
            this.permission = permission;
        }

        @Override
        public Void run() {
            AccessController.checkPermission(this.permission);
            return null;
        }

        public String toString() {
            return this.permission.toString();
        }
    }

    public class ShutdownAction
    implements PrivilegedAction<Void> {
        protected final Permission permission;

        public ShutdownAction(Permission permission) {
            this.permission = permission;
        }

        @Override
        public Void run() {
            AccessController.checkPermission(this.permission);
            return null;
        }

        public String toString() {
            return this.permission.toString();
        }
    }
}

